#pragma once

#ifdef __cplusplus
extern "C"
{
#endif

// macro to convert PDF units in floating point to fixed point used by GDI
#define FLOAT2FIX(f) (FIX)((f) * 160.0f)

// macro to convert floating point to LONG units
#define FLOAT2LONG(f) (LONG)((f) * 10.0f)

// macro to convert RGB colors into GDIBRUSH colors
#define RGB2GDIBRUSH(r, g, b) (((ULONG)(r)) | ((ULONG)(g) << 8) | ((ULONG)(b) << 16))
#define RGB2GDICOLOR(c) RGB2GDIBRUSH(GetRValue((c)), GetGValue((c)), GetBValue((c)))

typedef struct _UNICODE_STRING
{
	WORD	Header;
	WCHAR	String[128];
} UNICODE_STRING;

#define INIT_UNICODE_STRING(s, v) \
	(s).Header = 0xFEFF; \
	wcsncpy_s((s).String, _countof((s).String), (LPWSTR)(v"\0\0"), _countof((s).String));

#ifndef _WINDDI_

/* The following definitions and structures are taken from winddi.h */

typedef FLOAT FLOATL;
typedef LONG  FIX;
typedef FIX  *PFIX;

typedef union _FLOAT_LONG
{
	FLOATL   e;
	LONG     l;
} FLOAT_LONG, *PFLOAT_LONG;

typedef struct  _POINTFIX
{
	FIX   x;
	FIX   y;
} POINTFIX, *PPOINTFIX;

typedef struct _RECTFX
{
	FIX   xLeft;
	FIX   yTop;
	FIX   xRight;
	FIX   yBottom;
} RECTFX, *PRECTFX; 

typedef struct  _LINEATTRS
{
	FLONG       fl;
	ULONG       iJoin;
	ULONG       iEndCap;
	FLOAT_LONG  elWidth;
	FLOATL      eMiterLimit;
	ULONG       cstyle;
	PFLOAT_LONG pstyle;
	FLOAT_LONG  elStyleState;
} LINEATTRS, *PLINEATTRS;

#define LA_GEOMETRIC        0x00000001
#define LA_ALTERNATE        0x00000002
#define LA_STARTGAP         0x00000004
#define LA_STYLED           0x00000008

#define JOIN_ROUND          0L
#define JOIN_BEVEL          1L
#define JOIN_MITER          2L

#define ENDCAP_ROUND        0L
#define ENDCAP_SQUARE       1L
#define ENDCAP_BUTT         2L

typedef struct _PATHOBJ
{
	FLONG   fl;
	ULONG   cCurves;
} PATHOBJ;

typedef struct _BRUSHOBJ
{
	ULONG  iSolidColor;
	PVOID  pvRbrush;
	FLONG  flColorType;
} BRUSHOBJ;

// CLIPOBJ definitions
#define DC_TRIVIAL      0
#define DC_RECT         1
#define DC_COMPLEX      3

#define FC_RECT         1
#define FC_RECT4        2
#define FC_COMPLEX      3

typedef struct _CLIPOBJ
{
	ULONG   iUniq;
	RECTL   rclBounds;
	BYTE    iDComplexity;
	BYTE    iFComplexity;
	BYTE    iMode;
	BYTE    fjOptions;
} CLIPOBJ;

//
// BRUSHOBJ::flColorType
//
#define BR_DEVICE_ICM    0x01
#define BR_HOST_ICM      0x02
#define BR_CMYKCOLOR     0x04

/** @name Path Object Handline Functions
* \anchor PathObject
*  
* @code
//
// This sample shows how to 
//
* @endcode
*/
///@{

/**
 * @brief 
 * 
 * @param ppo Path object returned by RTPdfCreatePath
 * @param ptfx 
 * @return BOOL 
 */
BOOL APIENTRY PATHOBJ_bMoveTo(
	PATHOBJ    *ppo,
	POINTFIX    ptfx
);

/**
* @brief
*
* @param ppo Path object returned by RTPdfCreatePath
* @param pptfx
* @param cptfx
* @return BOOL
*/
BOOL APIENTRY PATHOBJ_bPolyLineTo(
	PATHOBJ     *ppo,
	POINTFIX	*pptfx,
	ULONG		cptfx
);

/**
* @brief
*
* @param ppo Path object returned by RTPdfCreatePath
* @param pptfx
* @param cptfx
* @return BOOL
*/
BOOL APIENTRY PATHOBJ_bPolyBezierTo(
	PATHOBJ  *ppo,
	POINTFIX *pptfx,
	ULONG    cptfx
);

///@}

/// @private
VOID APIENTRY PATHOBJ_vGetBounds(
	PATHOBJ *ppo,
	PRECTFX prectfx
);

/* End of winddi.h structures */

#endif // _WINDDI_

#ifdef __cplusplus
}
#endif
