/**************************************************************************/
/*                                                                        */
/*  File: SERDEMO.C                              Copyright (c) 1996,2015  */
/*  Version: 6.0                                 On Time Informatik GmbH  */
/*                                                                        */
/*                                                                        */
/*                                      On Time        /////////////----- */
/*                                    Informatik GmbH /////////////       */
/* --------------------------------------------------/////////////        */
/*                                  Real-Time and System Software         */
/*                                                                        */
/**************************************************************************/

/* Serial I/O demo program for RTTarget-32

   This small program uses module RTTCom delivered with RTTarget-32 to
   communicate over a serial port. To run it, connect another PC on COM2
   of the target computer equiped with a terminal program. The target
   running SERDemo will display any characters it receives on the screen
   and it will send them back on the same port. Each time a carriage return
   character is received, a longer message is sent to demonstrate the
   use of the block-oriented send functions of RTTCom.

   The program is terminated by pressing escape on the keyboard
   (if available).

   Multithreaded RTKernel-32 programs should not use RTTCOM. Rather, use
   RTCOM demonstrated in demo program COMDEMO.
*/

#define STRICT
#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <stdlib.h>
#include <stdio.h>
#include <time.h>

#include <conio.h>                        // needed for kbhit()
#include <rttarget.h>                     // general RTTarget-32 functions
#include <rttcom.h>                       // serial I/O functions of RTTarget-32

#include "RTPDF-32\RTPDF-32.h"
#include "RTPDF-32\acTable.h"

const int Port = RT_COM2;                 // the port to be used. change if required

const BYTE Test_Image_Jpeg[] = {
	0xFF, 0xD8, 0xFF, 0xE1, 0x0A, 0x7E, 0x45, 0x78, 0x69, 0x66, 0x00, 0x00, 0x49, 0x49, 0x2A, 0x00, 0x08, 0x00, 0x00, 0x00, 0x0C, 0x00, 0x00, 0x01, 0x03, 0x00, 0x01, 0x00, 0x00, 0x00, 0xB8, 0x00, 0x00, 0x00, 0x01, 0x01, 0x03, 0x00, 0x01, 0x00, 0x00, 0x00, 0x2C, 0x00, 0x00, 0x00, 0x02, 0x01, 0x03, 0x00,
	0x03, 0x00, 0x00, 0x00, 0x9E, 0x00, 0x00, 0x00, 0x06, 0x01, 0x03, 0x00, 0x01, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x12, 0x01, 0x03, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x15, 0x01, 0x03, 0x00, 0x01, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x1A, 0x01, 0x05, 0x00, 0x01, 0x00,
	0x00, 0x00, 0xA4, 0x00, 0x00, 0x00, 0x1B, 0x01, 0x05, 0x00, 0x01, 0x00, 0x00, 0x00, 0xAC, 0x00, 0x00, 0x00, 0x28, 0x01, 0x03, 0x00, 0x01, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x31, 0x01, 0x02, 0x00, 0x1E, 0x00, 0x00, 0x00, 0xB4, 0x00, 0x00, 0x00, 0x32, 0x01, 0x02, 0x00, 0x14, 0x00, 0x00, 0x00,
	0xD2, 0x00, 0x00, 0x00, 0x69, 0x87, 0x04, 0x00, 0x01, 0x00, 0x00, 0x00, 0xE8, 0x00, 0x00, 0x00, 0x20, 0x01, 0x00, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x80, 0xFC, 0x0A, 0x00, 0x10, 0x27, 0x00, 0x00, 0x80, 0xFC, 0x0A, 0x00, 0x10, 0x27, 0x00, 0x00, 0x41, 0x64, 0x6F, 0x62, 0x65, 0x20, 0x50, 0x68,
	0x6F, 0x74, 0x6F, 0x73, 0x68, 0x6F, 0x70, 0x20, 0x43, 0x53, 0x36, 0x20, 0x28, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x29, 0x00, 0x32, 0x30, 0x31, 0x35, 0x3A, 0x30, 0x34, 0x3A, 0x30, 0x33, 0x20, 0x31, 0x39, 0x3A, 0x30, 0x37, 0x3A, 0x32, 0x30, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x90, 0x07, 0x00,
	0x04, 0x00, 0x00, 0x00, 0x30, 0x32, 0x32, 0x31, 0x01, 0xA0, 0x03, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x02, 0xA0, 0x04, 0x00, 0x01, 0x00, 0x00, 0x00, 0xB8, 0x00, 0x00, 0x00, 0x03, 0xA0, 0x04, 0x00, 0x01, 0x00, 0x00, 0x00, 0x27, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x06, 0x00, 0x03, 0x01, 0x03, 0x00, 0x01, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x1A, 0x01, 0x05, 0x00, 0x01, 0x00, 0x00, 0x00, 0x6E, 0x01, 0x00, 0x00, 0x1B, 0x01, 0x05, 0x00, 0x01, 0x00, 0x00, 0x00, 0x76, 0x01, 0x00, 0x00, 0x28, 0x01, 0x03, 0x00, 0x01, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
	0x01, 0x02, 0x04, 0x00, 0x01, 0x00, 0x00, 0x00, 0x7E, 0x01, 0x00, 0x00, 0x02, 0x02, 0x04, 0x00, 0x01, 0x00, 0x00, 0x00, 0xF8, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x48, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0xFF, 0xD8, 0xFF, 0xED, 0x00, 0x0C,
	0x41, 0x64, 0x6F, 0x62, 0x65, 0x5F, 0x43, 0x4D, 0x00, 0x01, 0xFF, 0xEE, 0x00, 0x0E, 0x41, 0x64, 0x6F, 0x62, 0x65, 0x00, 0x64, 0x80, 0x00, 0x00, 0x00, 0x01, 0xFF, 0xDB, 0x00, 0x84, 0x00, 0x0C, 0x08, 0x08, 0x08, 0x09, 0x08, 0x0C, 0x09, 0x09, 0x0C, 0x11, 0x0B, 0x0A, 0x0B, 0x11, 0x15, 0x0F, 0x0C, 0x0C,
	0x0F, 0x15, 0x18, 0x13, 0x13, 0x15, 0x13, 0x13, 0x18, 0x11, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x11, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x01, 0x0D, 0x0B, 0x0B, 0x0D,
	0x0E, 0x0D, 0x10, 0x0E, 0x0E, 0x10, 0x14, 0x0E, 0x0E, 0x0E, 0x14, 0x14, 0x0E, 0x0E, 0x0E, 0x0E, 0x14, 0x11, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x11, 0x11, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x11, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C,
	0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0xFF, 0xC0, 0x00, 0x11, 0x08, 0x00, 0x22, 0x00, 0xA0, 0x03, 0x01, 0x22, 0x00, 0x02, 0x11, 0x01, 0x03, 0x11, 0x01, 0xFF, 0xDD, 0x00, 0x04, 0x00, 0x0A, 0xFF, 0xC4, 0x01, 0x3F, 0x00, 0x00, 0x01, 0x05, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x01, 0x02, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B, 0x01, 0x00, 0x01, 0x05, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B, 0x10, 0x00, 0x01,
	0x04, 0x01, 0x03, 0x02, 0x04, 0x02, 0x05, 0x07, 0x06, 0x08, 0x05, 0x03, 0x0C, 0x33, 0x01, 0x00, 0x02, 0x11, 0x03, 0x04, 0x21, 0x12, 0x31, 0x05, 0x41, 0x51, 0x61, 0x13, 0x22, 0x71, 0x81, 0x32, 0x06, 0x14, 0x91, 0xA1, 0xB1, 0x42, 0x23, 0x24, 0x15, 0x52, 0xC1, 0x62, 0x33, 0x34, 0x72, 0x82, 0xD1, 0x43,
	0x07, 0x25, 0x92, 0x53, 0xF0, 0xE1, 0xF1, 0x63, 0x73, 0x35, 0x16, 0xA2, 0xB2, 0x83, 0x26, 0x44, 0x93, 0x54, 0x64, 0x45, 0xC2, 0xA3, 0x74, 0x36, 0x17, 0xD2, 0x55, 0xE2, 0x65, 0xF2, 0xB3, 0x84, 0xC3, 0xD3, 0x75, 0xE3, 0xF3, 0x46, 0x27, 0x94, 0xA4, 0x85, 0xB4, 0x95, 0xC4, 0xD4, 0xE4, 0xF4, 0xA5, 0xB5,
	0xC5, 0xD5, 0xE5, 0xF5, 0x56, 0x66, 0x76, 0x86, 0x96, 0xA6, 0xB6, 0xC6, 0xD6, 0xE6, 0xF6, 0x37, 0x47, 0x57, 0x67, 0x77, 0x87, 0x97, 0xA7, 0xB7, 0xC7, 0xD7, 0xE7, 0xF7, 0x11, 0x00, 0x02, 0x02, 0x01, 0x02, 0x04, 0x04, 0x03, 0x04, 0x05, 0x06, 0x07, 0x07, 0x06, 0x05, 0x35, 0x01, 0x00, 0x02, 0x11, 0x03,
	0x21, 0x31, 0x12, 0x04, 0x41, 0x51, 0x61, 0x71, 0x22, 0x13, 0x05, 0x32, 0x81, 0x91, 0x14, 0xA1, 0xB1, 0x42, 0x23, 0xC1, 0x52, 0xD1, 0xF0, 0x33, 0x24, 0x62, 0xE1, 0x72, 0x82, 0x92, 0x43, 0x53, 0x15, 0x63, 0x73, 0x34, 0xF1, 0x25, 0x06, 0x16, 0xA2, 0xB2, 0x83, 0x07, 0x26, 0x35, 0xC2, 0xD2, 0x44, 0x93,
	0x54, 0xA3, 0x17, 0x64, 0x45, 0x55, 0x36, 0x74, 0x65, 0xE2, 0xF2, 0xB3, 0x84, 0xC3, 0xD3, 0x75, 0xE3, 0xF3, 0x46, 0x94, 0xA4, 0x85, 0xB4, 0x95, 0xC4, 0xD4, 0xE4, 0xF4, 0xA5, 0xB5, 0xC5, 0xD5, 0xE5, 0xF5, 0x56, 0x66, 0x76, 0x86, 0x96, 0xA6, 0xB6, 0xC6, 0xD6, 0xE6, 0xF6, 0x27, 0x37, 0x47, 0x57, 0x67,
	0x77, 0x87, 0x97, 0xA7, 0xB7, 0xC7, 0xFF, 0xDA, 0x00, 0x0C, 0x03, 0x01, 0x00, 0x02, 0x11, 0x03, 0x11, 0x00, 0x3F, 0x00, 0xF5, 0x54, 0x92, 0x49, 0x25, 0x29, 0x25, 0x9D, 0xD7, 0xBA, 0x93, 0xBA, 0x5F, 0x4A, 0xBF, 0x2E, 0xB6, 0x1B, 0x72, 0x00, 0x15, 0xE2, 0xD2, 0x35, 0x36, 0x5F, 0x6B, 0x85, 0x18, 0x94,
	0xFF, 0x00, 0xD7, 0x32, 0x2C, 0xAF, 0xFB, 0x0A, 0x87, 0xD4, 0xAE, 0xB1, 0x95, 0xD5, 0x7A, 0x28, 0x19, 0xE7, 0xFC, 0xA9, 0x81, 0x6D, 0x98, 0x5D, 0x45, 0xA6, 0x34, 0xBE, 0x93, 0xB5, 0xC7, 0xD9, 0xEC, 0x76, 0xF6, 0x6C, 0x7F, 0xE8, 0xFF, 0x00, 0x46, 0x92, 0x9E, 0x81, 0x25, 0xC7, 0xFD, 0x7D, 0xC9, 0xFA,
	0xCB, 0xD3, 0x71, 0xE9, 0xCA, 0xE8, 0x39, 0xD6, 0x8C, 0x9C, 0xCC, 0x8A, 0xF1, 0x6A, 0xC1, 0x35, 0xD0, 0xF6, 0x12, 0xE6, 0x5A, 0xF9, 0xAD, 0xD7, 0x55, 0xEA, 0xFA, 0x9F, 0xA1, 0xFC, 0xEB, 0x7F, 0xEB, 0x6B, 0x77, 0xEA, 0xE7, 0x5A, 0xA3, 0xAE, 0xF4, 0x4C, 0x4E, 0xAB, 0x4C, 0x34, 0x64, 0xD6, 0x0B, 0xD8,
	0x27, 0xD9, 0x60, 0xF6, 0x5F, 0x57, 0xBB, 0xFD, 0x1D, 0xAD, 0x7B, 0x12, 0x53, 0xA6, 0x92, 0xE1, 0x7E, 0xB7, 0xFD, 0x65, 0xEB, 0x95, 0x7D, 0x61, 0xE9, 0xDD, 0x2B, 0xA3, 0x5A, 0xEC, 0x5C, 0x47, 0x65, 0x53, 0x87, 0xD4, 0x33, 0x05, 0x6C, 0x7C, 0x5D, 0x95, 0xB6, 0xCA, 0xB1, 0xEA, 0x19, 0x35, 0xBD, 0xBE,
	0xAD, 0x18, 0x8D, 0xFB, 0x4F, 0xE8, 0xF7, 0xD7, 0xFA, 0xC5, 0x5E, 0xB2, 0xB5, 0xF5, 0xC1, 0x9F, 0x5A, 0xFA, 0x57, 0x4D, 0x1D, 0x4F, 0xA4, 0x75, 0x3B, 0xAC, 0xAF, 0x15, 0xAD, 0xFB, 0x75, 0x0F, 0xAA, 0x87, 0xBD, 0xD5, 0x37, 0xF9, 0xEC, 0xBC, 0x77, 0x7A, 0x3E, 0xDB, 0xEB, 0xFA, 0x76, 0xD6, 0xFF, 0x00,
	0xD0, 0x7F, 0x53, 0xD2, 0xFD, 0x2A, 0x53, 0xD8, 0x24, 0xB0, 0x33, 0xBA, 0xDE, 0x2B, 0x7E, 0xA9, 0xB7, 0xA9, 0xE2, 0xE5, 0x5D, 0x6B, 0x6F, 0xA6, 0xB1, 0x87, 0x75, 0x41, 0x8E, 0xC9, 0xB6, 0xEB, 0x36, 0xD7, 0x8F, 0x4B, 0x2B, 0xF4, 0xAD, 0xA7, 0xED, 0x57, 0x5D, 0xFA, 0x2B, 0x6B, 0xFB, 0x3F, 0xE8, 0xBF,
	0x49, 0xFA, 0x35, 0x5F, 0xEC, 0x1F, 0x59, 0xF1, 0xFE, 0xAF, 0xDD, 0x93, 0x9B, 0xD6, 0xAD, 0x1D, 0x51, 0x94, 0xBA, 0xF7, 0x1A, 0xA9, 0xC7, 0xF4, 0x58, 0xE6, 0xB1, 0xCF, 0xFB, 0x3B, 0x6A, 0x75, 0x2E, 0xF5, 0x6B, 0xDD, 0xEC, 0x7D, 0x8F, 0x7F, 0xA9, 0x67, 0xFC, 0x0A, 0x4A, 0x7A, 0x74, 0x97, 0x39, 0xF5,
	0x1B, 0x27, 0xAA, 0x75, 0x0E, 0x85, 0x8F, 0xD5, 0xFA, 0x9E, 0x6B, 0xF2, 0xAE, 0xCD, 0x61, 0x77, 0xA4, 0x59, 0x5B, 0x2B, 0xAE, 0x1C, 0xF6, 0xFE, 0x89, 0xB4, 0xD6, 0xCB, 0x3D, 0xCD, 0x0D, 0xDD, 0xEA, 0xD9, 0x62, 0x1E, 0x5B, 0x3A, 0xD7, 0xFC, 0xEA, 0xC7, 0xC0, 0xAB, 0xAB, 0xDF, 0x56, 0x16, 0x55, 0x17,
	0x65, 0xBE, 0x91, 0x56, 0x39, 0x2D, 0x35, 0x3E, 0x8A, 0xC5, 0x15, 0x5E, 0xFA, 0x1C, 0xFF, 0x00, 0x46, 0xCF, 0xB4, 0xFE, 0x7E, 0xFB, 0x7F, 0x47, 0xFC, 0xE7, 0xBD, 0x25, 0x3D, 0x3A, 0x4B, 0x82, 0xEB, 0xBD, 0x7F, 0xEB, 0x07, 0xD5, 0xAF, 0xAC, 0x75, 0xB4, 0xE4, 0x5B, 0xD5, 0x7A, 0x3D, 0x78, 0xC3, 0x2B,
	0xA8, 0x50, 0xF6, 0x52, 0xDB, 0x6A, 0xA9, 0xD6, 0xFD, 0x97, 0xD7, 0xA5, 0xF4, 0xD7, 0x4D, 0xB7, 0x7A, 0x4F, 0xD8, 0xED, 0x9E, 0xFF, 0x00, 0xCF, 0xF5, 0x7F, 0xD2, 0x53, 0xD3, 0xF5, 0x3B, 0x5F, 0x9B, 0xD1, 0x1D, 0x9D, 0xD2, 0xB3, 0x9D, 0x8F, 0xFA, 0x23, 0x93, 0x8F, 0x93, 0x43, 0x6B, 0xB0, 0x3D, 0xA1,
	0x8E, 0x7B, 0x1A, 0xE6, 0x64, 0x57, 0x6B, 0x1D, 0x5B, 0xFF, 0x00, 0xED, 0xC4, 0x94, 0xEB, 0x24, 0xB9, 0x4C, 0x73, 0xD6, 0xED, 0xFA, 0x98, 0xCE, 0xAE, 0xEE, 0xAF, 0x70, 0xCF, 0xB3, 0x10, 0x75, 0x00, 0xF1, 0x56, 0x3E, 0xC6, 0x93, 0x47, 0xAF, 0xF6, 0x5F, 0x47, 0xD0, 0xD9, 0xF6, 0x7D, 0xEE, 0xFF, 0x00,
	0x8F, 0xFF, 0x00, 0x87, 0x47, 0xFA, 0x8D, 0x93, 0xD5, 0x3A, 0x8F, 0x41, 0xC7, 0xEA, 0xFD, 0x4B, 0x35, 0xF9, 0x76, 0xE6, 0xB0, 0xBB, 0xD2, 0x35, 0xD7, 0x5D, 0x75, 0xED, 0x7B, 0xD9, 0xFA, 0x26, 0xD1, 0x5B, 0x1E, 0xEF, 0x6B, 0x7F, 0xC2, 0xD9, 0x62, 0x4A, 0x7A, 0x44, 0x97, 0x17, 0x6F, 0xF8, 0xCA, 0xC1,
	0xDC, 0x0E, 0x2E, 0x05, 0xF7, 0x54, 0x78, 0xB1, 0xEE, 0x65, 0x72, 0x3C, 0x5B, 0x5B, 0x9C, 0xF7, 0x7F, 0xDB, 0x9E, 0x9A, 0xDE, 0xFA, 0xBF, 0xF5, 0x87, 0x07, 0xAF, 0xE3, 0xDB, 0x76, 0x2B, 0x1F, 0x59, 0xA1, 0xE2, 0xBB, 0x59, 0x60, 0x12, 0x1C, 0x40, 0x78, 0xDA, 0xEA, 0xDD, 0x63, 0x1E, 0xDD, 0xAE, 0xFD,
	0xE5, 0x2C, 0xF0, 0x65, 0x84, 0x78, 0xA5, 0x02, 0x23, 0xFC, 0x56, 0x47, 0x2E, 0x39, 0x1E, 0x18, 0xC8, 0x12, 0xEB, 0x24, 0x98, 0x42, 0x45, 0x44, 0xBD, 0xFF, 0xD0, 0xF5, 0x54, 0x92, 0x4C, 0x41, 0x20, 0x80, 0x60, 0x9E, 0x0F, 0x82, 0x4A, 0x79, 0x0E, 0xBF, 0x99, 0x97, 0x9B, 0xF5, 0x9B, 0x17, 0x0F, 0x07,
	0x01, 0xFD, 0x56, 0xAE, 0x85, 0x19, 0x99, 0x74, 0xD7, 0x65, 0x15, 0xED, 0xC9, 0xB9, 0xB6, 0x57, 0xD3, 0x7D, 0x4F, 0xB5, 0xBA, 0xB7, 0x7E, 0x82, 0x9F, 0xB4, 0xE4, 0xFE, 0x8B, 0xFD, 0x2E, 0x3A, 0xCE, 0xC0, 0xCE, 0xCE, 0xE8, 0xFF, 0x00, 0x5F, 0x05, 0xD9, 0xDD, 0x3D, 0xFD, 0x2B, 0x0B, 0xEB, 0x3B, 0x05,
	0x4E, 0x65, 0x96, 0xD3, 0x6B, 0x7E, 0xD9, 0x4F, 0xF3, 0x76, 0x35, 0xD8, 0xAE, 0xB7, 0x67, 0xAC, 0xC7, 0xFA, 0x5B, 0x1F, 0xFC, 0xEE, 0x46, 0x47, 0xA8, 0xBA, 0x9E, 0x89, 0xF5, 0x79, 0xDD, 0x22, 0xFC, 0xAB, 0x87, 0x50, 0xC8, 0xCC, 0x19, 0xAF, 0x37, 0xE4, 0x37, 0x24, 0x54, 0x66, 0xF7, 0x06, 0x35, 0xD7,
	0x31, 0xF4, 0xD3, 0x4D, 0x8C, 0x6F, 0xA7, 0x53, 0x6A, 0xAF, 0x1F, 0xF9, 0x8A, 0x99, 0xFC, 0xDA, 0x1F, 0xD6, 0x3F, 0xAA, 0xB4, 0xFD, 0x62, 0xF4, 0x2B, 0xCB, 0xCD, 0xC8, 0xC7, 0xC7, 0xC7, 0x7B, 0x6E, 0xAE, 0xAC, 0x63, 0x5B, 0x08, 0xBD, 0xBB, 0x83, 0x32, 0x3D, 0x7B, 0x29, 0xB6, 0xE6, 0xB9, 0x8D, 0xB3,
	0xDA, 0xD6, 0x3D, 0x25, 0x35, 0x3E, 0xBB, 0x9D, 0x7E, 0xAF, 0xFF, 0x00, 0xE9, 0xEF, 0x0F, 0xF2, 0x5C, 0xB2, 0xA9, 0xEA, 0x34, 0x7D, 0x49, 0xEB, 0xBD, 0x63, 0x06, 0xF1, 0xB7, 0xA6, 0xE6, 0xD6, 0xEE, 0xAB, 0xD3, 0x18, 0x08, 0x6C, 0xDD, 0xA5, 0x79, 0x5D, 0x3E, 0x8D, 0x36, 0xFA, 0xB7, 0xDB, 0xB3, 0xEC,
	0xF4, 0xB7, 0xE8, 0x33, 0xFE, 0x31, 0x6E, 0x75, 0x0F, 0xAA, 0xB7, 0xF5, 0x31, 0x88, 0x33, 0x7A, 0xC6, 0x5B, 0xBE, 0xC3, 0x63, 0x32, 0x28, 0x35, 0xB3, 0x19, 0x87, 0xD7, 0xA8, 0xBD, 0xD5, 0xE4, 0xDB, 0xFA, 0xAB, 0x9A, 0xFD, 0xAD, 0xB3, 0x67, 0xA5, 0xFC, 0xC7, 0xFC, 0x12, 0xB7, 0x97, 0xF5, 0x7B, 0x0F,
	0xA8, 0x3B, 0xA6, 0x5D, 0xD4, 0x5C, 0xEC, 0xAC, 0xAE, 0x93, 0x68, 0xBE, 0x9C, 0x82, 0x1A, 0xD7, 0x39, 0xE1, 0xBB, 0x66, 0xC6, 0xB1, 0x9B, 0x36, 0xB9, 0xE2, 0xBB, 0xF6, 0x55, 0xE9, 0x7E, 0x9A, 0x9A, 0x92, 0x53, 0xC6, 0xF5, 0x8E, 0x9B, 0x77, 0x4D, 0x6F, 0xD5, 0x31, 0x96, 0x47, 0xED, 0x0C, 0xBE, 0xB3,
	0x5E, 0x5F, 0x50, 0x70, 0x88, 0x39, 0x37, 0xB9, 0xAF, 0xBD, 0xBE, 0xD2, 0xE6, 0x6D, 0xA7, 0xFA, 0x35, 0x3F, 0xF0, 0x55, 0x56, 0xBD, 0x14, 0x80, 0x64, 0x10, 0x0C, 0x8D, 0x67, 0xB8, 0x58, 0x3D, 0x67, 0xEA, 0x9F, 0xED, 0x9C, 0xDA, 0x72, 0xF2, 0xBA, 0x9E, 0x55, 0x7F, 0x63, 0xB9, 0xB9, 0x18, 0x34, 0xD2,
	0x28, 0x6B, 0x2A, 0xB5, 0x9B, 0x76, 0xD9, 0xFA, 0x4C, 0x7B, 0x9F, 0x7F, 0xB9, 0xBB, 0xBF, 0x4E, 0xF5, 0xB1, 0x4D, 0x19, 0x0C, 0xC3, 0x14, 0x59, 0x90, 0xEB, 0x6F, 0x0C, 0x2D, 0x39, 0x2E, 0x6B, 0x03, 0x8B, 0xBB, 0x5A, 0x6B, 0xAD, 0xAC, 0xA7, 0x77, 0xF6, 0x36, 0x24, 0xA7, 0x88, 0xFA, 0xB1, 0xD1, 0xA8,
	0xC6, 0xFA, 0xE7, 0xD5, 0x7A, 0x50, 0xB6, 0xC7, 0xF4, 0xDE, 0x89, 0x63, 0x32, 0xFA, 0x6E, 0x13, 0x8C, 0xD7, 0x55, 0xB9, 0x95, 0xEE, 0xB1, 0xE3, 0xF7, 0xBE, 0xCE, 0xC7, 0x59, 0x56, 0x2B, 0x1F, 0xBF, 0xD2, 0xF5, 0xAC, 0xB7, 0xFA, 0x47, 0xE9, 0x57, 0x65, 0xD6, 0x83, 0x8F, 0x46, 0xCF, 0x0D, 0x04, 0xB8,
	0xE3, 0x5D, 0x00, 0x72, 0x4E, 0xC7, 0x2C, 0xAC, 0x0F, 0xAA, 0x2F, 0xC1, 0xEA, 0xB6, 0xF5, 0x7A, 0xFA, 0xB6, 0x65, 0x99, 0xB9, 0x66, 0xBF, 0xB7, 0x1B, 0x1B, 0x8E, 0x6B, 0xB9, 0xB5, 0x00, 0xC6, 0x56, 0x69, 0x66, 0x35, 0x7E, 0x8F, 0xB0, 0x6C, 0xDF, 0x4B, 0xF7, 0xAE, 0x84, 0xA4, 0xA7, 0x9B, 0xFF, 0x00,
	0x17, 0x2F, 0x6B, 0xFE, 0xA4, 0xF4, 0xA7, 0x34, 0xC8, 0x15, 0xBD, 0xB3, 0xE6, 0xDB, 0x2C, 0x63, 0xBF, 0xE9, 0x35, 0x16, 0xEB, 0x6B, 0x77, 0xD7, 0xCC, 0x4A, 0x43, 0x87, 0xA9, 0x57, 0x4A, 0xC8, 0xB1, 0xED, 0xEE, 0x1A, 0xFB, 0xF1, 0x18, 0xC7, 0x7F, 0x69, 0xD5, 0x58, 0xAB, 0x63, 0xFD, 0x47, 0x77, 0x4C,
	0xBE, 0xEB, 0x3E, 0xAF, 0xF5, 0x6C, 0xAE, 0x93, 0x46, 0x43, 0xFD, 0x4B, 0x30, 0xDA, 0xDA, 0xAE, 0xA1, 0xAE, 0x3F, 0x48, 0xD1, 0x4E, 0x55, 0x6F, 0xF4, 0x77, 0x7F, 0xAF, 0xB1, 0x6A, 0xF4, 0x7E, 0x81, 0x8D, 0xD2, 0x9F, 0x7E, 0x47, 0xAD, 0x76, 0x66, 0x76, 0x59, 0x07, 0x27, 0x33, 0x25, 0xC1, 0xD6, 0x3C,
	0x36, 0x76, 0x56, 0x36, 0x35, 0x95, 0x55, 0x4D, 0x7B, 0xBF, 0x45, 0x55, 0x55, 0xA4, 0xA7, 0x29, 0xE2, 0xBB, 0x3F, 0xC6, 0x3B, 0xA9, 0xB1, 0xA1, 0xCC, 0x77, 0x43, 0x21, 0xEC, 0x70, 0x04, 0x16, 0xBB, 0x2B, 0x69, 0x6B, 0x81, 0xFD, 0xE5, 0x90, 0xF6, 0xBF, 0xEA, 0x3E, 0x65, 0xBD, 0x36, 0xFB, 0x4F, 0xFC,
	0xD4, 0xEA, 0xC2, 0xD6, 0xE1, 0xDB, 0x64, 0xB8, 0x61, 0x64, 0x3D, 0xAF, 0x71, 0xC5, 0x75, 0x90, 0xF7, 0xFD, 0x96, 0xFF, 0x00, 0xCC, 0xFF, 0x00, 0xB7, 0x3F, 0xEE, 0x55, 0xD7, 0x74, 0x3F, 0xF3, 0x5A, 0xFF, 0x00, 0xDB, 0x3F, 0xB6, 0xFF, 0x00, 0x6B, 0x65, 0x7D, 0xB8, 0xB3, 0xEC, 0xFF, 0x00, 0x43, 0x1F,
	0xD2, 0xFB, 0x37, 0xA9, 0xF6, 0x8F, 0xB2, 0x7A, 0x5F, 0x66, 0xFD, 0xFF, 0x00, 0xF0, 0xFE, 0xA7, 0xDA, 0x3F, 0xE1, 0x16, 0xA7, 0x54, 0xE9, 0x78, 0x7D, 0x57, 0x02, 0xFE, 0x9D, 0x9C, 0xC1, 0x66, 0x36, 0x43, 0x76, 0x3D, 0xBD, 0xFC, 0x5A, 0xF6, 0x9F, 0xCD, 0xB1, 0x8F, 0xF7, 0xD6, 0xEF, 0xDF, 0x49, 0x4E,
	0x26, 0x21, 0x03, 0xFC, 0x5B, 0xD0, 0x4F, 0xFE, 0x52, 0xB7, 0xFF, 0x00, 0x6D, 0x42, 0x7F, 0xF1, 0x74, 0x7F, 0xEC, 0x23, 0xA5, 0xC7, 0x3E, 0x93, 0xFF, 0x00, 0xF3, 0xE5, 0x8A, 0xED, 0xDF, 0x57, 0x8B, 0xFA, 0x16, 0x3F, 0x43, 0xA7, 0x3A, 0xFC, 0x5C, 0x6A, 0x68, 0x6E, 0x2D, 0xB6, 0x54, 0x2B, 0xF5, 0x6C,
	0xA9, 0xB5, 0xFD, 0x9B, 0x61, 0x7D, 0xD5, 0x5C, 0xDA, 0xB7, 0xB7, 0xDD, 0xEA, 0x54, 0xCF, 0x51, 0x4B, 0xEA, 0xFF, 0x00, 0x40, 0xFD, 0x83, 0x8C, 0x30, 0x69, 0xCD, 0xBF, 0x27, 0x0A, 0xA6, 0x86, 0xE3, 0xD3, 0x78, 0xA8, 0x9A, 0xF5, 0x73, 0xDF, 0xB6, 0xEA, 0x2A, 0xA2, 0xCB, 0x37, 0x6E, 0xFF, 0x00, 0x0A,
	0x92, 0x9E, 0x6B, 0x17, 0xFC, 0x59, 0x38, 0x50, 0xC6, 0xE4, 0xF5, 0x27, 0x7A, 0x82, 0x09, 0x14, 0xD4, 0xD0, 0xC0, 0x67, 0x77, 0xF8, 0x52, 0xF7, 0x3D, 0x60, 0xF5, 0x6F, 0xF1, 0x82, 0xFB, 0x1D, 0x50, 0xFA, 0xAC, 0xD3, 0xD1, 0xD8, 0xD3, 0x60, 0xCC, 0x61, 0xA7, 0x1F, 0xF4, 0x8E, 0x96, 0x32, 0x97, 0x6D,
	0x8B, 0xB6, 0xBA, 0xBD, 0x96, 0x7F, 0xDB, 0x8B, 0xD6, 0x16, 0x76, 0x5F, 0xD5, 0xCE, 0x81, 0x9B, 0x69, 0xBF, 0x2F, 0xA6, 0xE2, 0xDF, 0x71, 0x32, 0x6C, 0xB2, 0x96, 0x39, 0xC4, 0xFF, 0x00, 0x29, 0xE5, 0xBB, 0x9C, 0xA7, 0x97, 0x31, 0x39, 0x9F, 0xD6, 0x1E, 0x2E, 0xC1, 0x8E, 0x38, 0xA3, 0x1F, 0x90, 0x70,
	0xF8, 0xBC, 0xB7, 0xF8, 0xB0, 0xEA, 0xDD, 0x43, 0xAA, 0x59, 0xD5, 0xAD, 0xCF, 0xCC, 0xB3, 0x36, 0xC6, 0x3A, 0x80, 0x0B, 0xDD, 0x2D, 0x6C, 0x8B, 0x65, 0xB5, 0x56, 0xCD, 0xB5, 0x55, 0xFC, 0xAD, 0x8D, 0x5D, 0xDA, 0x0E, 0x36, 0x26, 0x2E, 0x25, 0x42, 0x9C, 0x5A, 0x6B, 0xC7, 0xA8, 0x71, 0x5D, 0x4D, 0x0C,
	0x68, 0xFE, 0xCB, 0x03, 0x5A, 0x8A, 0x54, 0x52, 0x20, 0x92, 0x40, 0xA5, 0xE0, 0x50, 0x7F, 0xFF, 0xD1, 0xF5, 0x54, 0x97, 0xCA, 0xA9, 0x24, 0xA7, 0xEA, 0xA4, 0x97, 0xCA, 0xA9, 0x24, 0xA7, 0xEA, 0xA4, 0x97, 0xCA, 0xA9, 0x24, 0xA7, 0xEA, 0xA4, 0x97, 0xCA, 0xA9, 0x24, 0xA7, 0xEA, 0xA4, 0x97, 0xCA, 0xA9,
	0x24, 0xA7, 0xEA, 0xA4, 0x97, 0xCA, 0xA9, 0x24, 0xA7, 0xEA, 0xA4, 0x97, 0xCA, 0xA9, 0x24, 0xA7, 0xEA, 0xA4, 0x97, 0xCA, 0xA9, 0x24, 0xA7, 0xEA, 0xA4, 0x97, 0xCA, 0xA9, 0x24, 0xA7, 0xEA, 0xA4, 0xC5, 0x7C, 0xAC, 0x92, 0x4A, 0x7F, 0xFF, 0xD9, 0xFF, 0xED, 0x11, 0xFA, 0x50, 0x68, 0x6F, 0x74, 0x6F, 0x73,
	0x68, 0x6F, 0x70, 0x20, 0x33, 0x2E, 0x30, 0x00, 0x38, 0x42, 0x49, 0x4D, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0x1C, 0x01, 0x5A, 0x00, 0x03, 0x1B, 0x25, 0x47, 0x1C, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x38, 0x42, 0x49, 0x4D, 0x04, 0x25, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0xCD, 0xCF,
	0xFA, 0x7D, 0xA8, 0xC7, 0xBE, 0x09, 0x05, 0x70, 0x76, 0xAE, 0xAF, 0x05, 0xC3, 0x4E, 0x38, 0x42, 0x49, 0x4D, 0x04, 0x3A, 0x00, 0x00, 0x00, 0x00, 0x00, 0xE5, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0B, 0x70, 0x72, 0x69, 0x6E, 0x74, 0x4F, 0x75, 0x74, 0x70, 0x75,
	0x74, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x50, 0x73, 0x74, 0x53, 0x62, 0x6F, 0x6F, 0x6C, 0x01, 0x00, 0x00, 0x00, 0x00, 0x49, 0x6E, 0x74, 0x65, 0x65, 0x6E, 0x75, 0x6D, 0x00, 0x00, 0x00, 0x00, 0x49, 0x6E, 0x74, 0x65, 0x00, 0x00, 0x00, 0x00, 0x43, 0x6C, 0x72, 0x6D, 0x00, 0x00, 0x00, 0x0F,
	0x70, 0x72, 0x69, 0x6E, 0x74, 0x53, 0x69, 0x78, 0x74, 0x65, 0x65, 0x6E, 0x42, 0x69, 0x74, 0x62, 0x6F, 0x6F, 0x6C, 0x00, 0x00, 0x00, 0x00, 0x0B, 0x70, 0x72, 0x69, 0x6E, 0x74, 0x65, 0x72, 0x4E, 0x61, 0x6D, 0x65, 0x54, 0x45, 0x58, 0x54, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0x70,
	0x72, 0x69, 0x6E, 0x74, 0x50, 0x72, 0x6F, 0x6F, 0x66, 0x53, 0x65, 0x74, 0x75, 0x70, 0x4F, 0x62, 0x6A, 0x63, 0x00, 0x00, 0x00, 0x0C, 0x00, 0x50, 0x00, 0x72, 0x00, 0x6F, 0x00, 0x6F, 0x00, 0x66, 0x00, 0x20, 0x00, 0x53, 0x00, 0x65, 0x00, 0x74, 0x00, 0x75, 0x00, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A,
	0x70, 0x72, 0x6F, 0x6F, 0x66, 0x53, 0x65, 0x74, 0x75, 0x70, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x42, 0x6C, 0x74, 0x6E, 0x65, 0x6E, 0x75, 0x6D, 0x00, 0x00, 0x00, 0x0C, 0x62, 0x75, 0x69, 0x6C, 0x74, 0x69, 0x6E, 0x50, 0x72, 0x6F, 0x6F, 0x66, 0x00, 0x00, 0x00, 0x09, 0x70, 0x72, 0x6F, 0x6F,
	0x66, 0x43, 0x4D, 0x59, 0x4B, 0x00, 0x38, 0x42, 0x49, 0x4D, 0x04, 0x3B, 0x00, 0x00, 0x00, 0x00, 0x02, 0x2D, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x70, 0x72, 0x69, 0x6E, 0x74, 0x4F, 0x75, 0x74, 0x70, 0x75, 0x74, 0x4F, 0x70, 0x74, 0x69, 0x6F, 0x6E, 0x73,
	0x00, 0x00, 0x00, 0x17, 0x00, 0x00, 0x00, 0x00, 0x43, 0x70, 0x74, 0x6E, 0x62, 0x6F, 0x6F, 0x6C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x43, 0x6C, 0x62, 0x72, 0x62, 0x6F, 0x6F, 0x6C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0x67, 0x73, 0x4D, 0x62, 0x6F, 0x6F, 0x6C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x43, 0x72, 0x6E,
	0x43, 0x62, 0x6F, 0x6F, 0x6C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x43, 0x6E, 0x74, 0x43, 0x62, 0x6F, 0x6F, 0x6C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4C, 0x62, 0x6C, 0x73, 0x62, 0x6F, 0x6F, 0x6C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4E, 0x67, 0x74, 0x76, 0x62, 0x6F, 0x6F, 0x6C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x45,
	0x6D, 0x6C, 0x44, 0x62, 0x6F, 0x6F, 0x6C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x49, 0x6E, 0x74, 0x72, 0x62, 0x6F, 0x6F, 0x6C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x63, 0x6B, 0x67, 0x4F, 0x62, 0x6A, 0x63, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0x47, 0x42, 0x43, 0x00, 0x00, 0x00,
	0x03, 0x00, 0x00, 0x00, 0x00, 0x52, 0x64, 0x20, 0x20, 0x64, 0x6F, 0x75, 0x62, 0x40, 0x6F, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x47, 0x72, 0x6E, 0x20, 0x64, 0x6F, 0x75, 0x62, 0x40, 0x6F, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x6C, 0x20, 0x20, 0x64,
	0x6F, 0x75, 0x62, 0x40, 0x6F, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x72, 0x64, 0x54, 0x55, 0x6E, 0x74, 0x46, 0x23, 0x52, 0x6C, 0x74, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x6C, 0x64, 0x20, 0x55, 0x6E, 0x74, 0x46, 0x23, 0x52, 0x6C,
	0x74, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0x73, 0x6C, 0x74, 0x55, 0x6E, 0x74, 0x46, 0x23, 0x50, 0x78, 0x6C, 0x40, 0x52, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x76, 0x65, 0x63, 0x74, 0x6F, 0x72, 0x44, 0x61, 0x74, 0x61, 0x62, 0x6F, 0x6F,
	0x6C, 0x01, 0x00, 0x00, 0x00, 0x00, 0x50, 0x67, 0x50, 0x73, 0x65, 0x6E, 0x75, 0x6D, 0x00, 0x00, 0x00, 0x00, 0x50, 0x67, 0x50, 0x73, 0x00, 0x00, 0x00, 0x00, 0x50, 0x67, 0x50, 0x43, 0x00, 0x00, 0x00, 0x00, 0x4C, 0x65, 0x66, 0x74, 0x55, 0x6E, 0x74, 0x46, 0x23, 0x52, 0x6C, 0x74, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x54, 0x6F, 0x70, 0x20, 0x55, 0x6E, 0x74, 0x46, 0x23, 0x52, 0x6C, 0x74, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x53, 0x63, 0x6C, 0x20, 0x55, 0x6E, 0x74, 0x46, 0x23, 0x50, 0x72, 0x63, 0x40, 0x59, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x63, 0x72, 0x6F, 0x70, 0x57, 0x68, 0x65, 0x6E, 0x50, 0x72, 0x69, 0x6E, 0x74, 0x69, 0x6E, 0x67, 0x62, 0x6F, 0x6F, 0x6C, 0x00, 0x00, 0x00, 0x00, 0x0E, 0x63, 0x72, 0x6F, 0x70, 0x52, 0x65, 0x63, 0x74, 0x42, 0x6F, 0x74, 0x74, 0x6F, 0x6D, 0x6C, 0x6F, 0x6E, 0x67, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x63, 0x72, 0x6F, 0x70, 0x52, 0x65, 0x63, 0x74, 0x4C, 0x65, 0x66, 0x74, 0x6C, 0x6F, 0x6E, 0x67, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0D, 0x63, 0x72, 0x6F, 0x70, 0x52, 0x65, 0x63, 0x74, 0x52, 0x69, 0x67, 0x68, 0x74, 0x6C, 0x6F, 0x6E, 0x67, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x0B, 0x63, 0x72, 0x6F, 0x70, 0x52, 0x65, 0x63, 0x74, 0x54, 0x6F, 0x70, 0x6C, 0x6F, 0x6E, 0x67, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x42, 0x49, 0x4D, 0x03, 0xED, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x48, 0x00, 0x00, 0x00, 0x01, 0x00, 0x02, 0x00, 0x48, 0x00, 0x00,
	0x00, 0x01, 0x00, 0x02, 0x38, 0x42, 0x49, 0x4D, 0x04, 0x26, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3F, 0x80, 0x00, 0x00, 0x38, 0x42, 0x49, 0x4D, 0x04, 0x0D, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x1E, 0x38, 0x42, 0x49, 0x4D,
	0x04, 0x19, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x1E, 0x38, 0x42, 0x49, 0x4D, 0x03, 0xF3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x38, 0x42, 0x49, 0x4D, 0x27, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x00, 0x01, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x38, 0x42, 0x49, 0x4D, 0x03, 0xF5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x00, 0x2F, 0x66, 0x66, 0x00, 0x01, 0x00, 0x6C, 0x66, 0x66, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x2F, 0x66, 0x66, 0x00, 0x01, 0x00, 0xA1, 0x99, 0x9A, 0x00, 0x06, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x01, 0x00, 0x32, 0x00, 0x00, 0x00, 0x01, 0x00, 0x5A, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x35, 0x00, 0x00, 0x00, 0x01, 0x00, 0x2D, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x38, 0x42, 0x49, 0x4D, 0x03, 0xF8, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x70, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x03, 0xE8, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF, 0x03, 0xE8, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x03, 0xE8, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x03, 0xE8, 0x00, 0x00, 0x38, 0x42, 0x49, 0x4D, 0x04, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x02, 0x40, 0x00, 0x00, 0x02, 0x40, 0x00, 0x00, 0x00, 0x00, 0x38, 0x42, 0x49, 0x4D, 0x04, 0x1E, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x38, 0x42, 0x49, 0x4D, 0x04, 0x1A, 0x00, 0x00, 0x00, 0x00, 0x03, 0x3D, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x27, 0x00, 0x00, 0x00, 0xB8, 0x00, 0x00, 0x00, 0x04, 0x00, 0x6C, 0x00, 0x6F, 0x00, 0x67,
	0x00, 0x6F, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xB8, 0x00, 0x00, 0x00, 0x27, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6E, 0x75, 0x6C, 0x6C, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
	0x06, 0x62, 0x6F, 0x75, 0x6E, 0x64, 0x73, 0x4F, 0x62, 0x6A, 0x63, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0x63, 0x74, 0x31, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x54, 0x6F, 0x70, 0x20, 0x6C, 0x6F, 0x6E, 0x67, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4C,
	0x65, 0x66, 0x74, 0x6C, 0x6F, 0x6E, 0x67, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x74, 0x6F, 0x6D, 0x6C, 0x6F, 0x6E, 0x67, 0x00, 0x00, 0x00, 0x27, 0x00, 0x00, 0x00, 0x00, 0x52, 0x67, 0x68, 0x74, 0x6C, 0x6F, 0x6E, 0x67, 0x00, 0x00, 0x00, 0xB8, 0x00, 0x00, 0x00, 0x06, 0x73, 0x6C, 0x69,
	0x63, 0x65, 0x73, 0x56, 0x6C, 0x4C, 0x73, 0x00, 0x00, 0x00, 0x01, 0x4F, 0x62, 0x6A, 0x63, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x73, 0x6C, 0x69, 0x63, 0x65, 0x00, 0x00, 0x00, 0x12, 0x00, 0x00, 0x00, 0x07, 0x73, 0x6C, 0x69, 0x63, 0x65, 0x49, 0x44, 0x6C, 0x6F, 0x6E, 0x67, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x67, 0x72, 0x6F, 0x75, 0x70, 0x49, 0x44, 0x6C, 0x6F, 0x6E, 0x67, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x6F, 0x72, 0x69, 0x67, 0x69, 0x6E, 0x65, 0x6E, 0x75, 0x6D, 0x00, 0x00, 0x00, 0x0C, 0x45, 0x53, 0x6C, 0x69, 0x63, 0x65, 0x4F, 0x72, 0x69, 0x67,
	0x69, 0x6E, 0x00, 0x00, 0x00, 0x0D, 0x61, 0x75, 0x74, 0x6F, 0x47, 0x65, 0x6E, 0x65, 0x72, 0x61, 0x74, 0x65, 0x64, 0x00, 0x00, 0x00, 0x00, 0x54, 0x79, 0x70, 0x65, 0x65, 0x6E, 0x75, 0x6D, 0x00, 0x00, 0x00, 0x0A, 0x45, 0x53, 0x6C, 0x69, 0x63, 0x65, 0x54, 0x79, 0x70, 0x65, 0x00, 0x00, 0x00, 0x00, 0x49,
	0x6D, 0x67, 0x20, 0x00, 0x00, 0x00, 0x06, 0x62, 0x6F, 0x75, 0x6E, 0x64, 0x73, 0x4F, 0x62, 0x6A, 0x63, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0x63, 0x74, 0x31, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x54, 0x6F, 0x70, 0x20, 0x6C, 0x6F, 0x6E, 0x67, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x4C, 0x65, 0x66, 0x74, 0x6C, 0x6F, 0x6E, 0x67, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x74, 0x6F, 0x6D, 0x6C, 0x6F, 0x6E, 0x67, 0x00, 0x00, 0x00, 0x27, 0x00, 0x00, 0x00, 0x00, 0x52, 0x67, 0x68, 0x74, 0x6C, 0x6F, 0x6E, 0x67, 0x00, 0x00, 0x00, 0xB8, 0x00,
	0x00, 0x00, 0x03, 0x75, 0x72, 0x6C, 0x54, 0x45, 0x58, 0x54, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6E, 0x75, 0x6C, 0x6C, 0x54, 0x45, 0x58, 0x54, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4D, 0x73, 0x67, 0x65, 0x54, 0x45, 0x58, 0x54, 0x00, 0x00, 0x00, 0x01,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x61, 0x6C, 0x74, 0x54, 0x61, 0x67, 0x54, 0x45, 0x58, 0x54, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0E, 0x63, 0x65, 0x6C, 0x6C, 0x54, 0x65, 0x78, 0x74, 0x49, 0x73, 0x48, 0x54, 0x4D, 0x4C, 0x62, 0x6F, 0x6F, 0x6C, 0x01, 0x00, 0x00, 0x00, 0x08, 0x63,
	0x65, 0x6C, 0x6C, 0x54, 0x65, 0x78, 0x74, 0x54, 0x45, 0x58, 0x54, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x68, 0x6F, 0x72, 0x7A, 0x41, 0x6C, 0x69, 0x67, 0x6E, 0x65, 0x6E, 0x75, 0x6D, 0x00, 0x00, 0x00, 0x0F, 0x45, 0x53, 0x6C, 0x69, 0x63, 0x65, 0x48, 0x6F, 0x72, 0x7A, 0x41, 0x6C,
	0x69, 0x67, 0x6E, 0x00, 0x00, 0x00, 0x07, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6C, 0x74, 0x00, 0x00, 0x00, 0x09, 0x76, 0x65, 0x72, 0x74, 0x41, 0x6C, 0x69, 0x67, 0x6E, 0x65, 0x6E, 0x75, 0x6D, 0x00, 0x00, 0x00, 0x0F, 0x45, 0x53, 0x6C, 0x69, 0x63, 0x65, 0x56, 0x65, 0x72, 0x74, 0x41, 0x6C, 0x69, 0x67, 0x6E,
	0x00, 0x00, 0x00, 0x07, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6C, 0x74, 0x00, 0x00, 0x00, 0x0B, 0x62, 0x67, 0x43, 0x6F, 0x6C, 0x6F, 0x72, 0x54, 0x79, 0x70, 0x65, 0x65, 0x6E, 0x75, 0x6D, 0x00, 0x00, 0x00, 0x11, 0x45, 0x53, 0x6C, 0x69, 0x63, 0x65, 0x42, 0x47, 0x43, 0x6F, 0x6C, 0x6F, 0x72, 0x54, 0x79, 0x70,
	0x65, 0x00, 0x00, 0x00, 0x00, 0x4E, 0x6F, 0x6E, 0x65, 0x00, 0x00, 0x00, 0x09, 0x74, 0x6F, 0x70, 0x4F, 0x75, 0x74, 0x73, 0x65, 0x74, 0x6C, 0x6F, 0x6E, 0x67, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x6C, 0x65, 0x66, 0x74, 0x4F, 0x75, 0x74, 0x73, 0x65, 0x74, 0x6C, 0x6F, 0x6E, 0x67, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x62, 0x6F, 0x74, 0x74, 0x6F, 0x6D, 0x4F, 0x75, 0x74, 0x73, 0x65, 0x74, 0x6C, 0x6F, 0x6E, 0x67, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0B, 0x72, 0x69, 0x67, 0x68, 0x74, 0x4F, 0x75, 0x74, 0x73, 0x65, 0x74, 0x6C, 0x6F, 0x6E, 0x67, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x38, 0x42, 0x49, 0x4D, 0x04, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x00, 0x00, 0x00, 0x02, 0x3F, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x42, 0x49, 0x4D, 0x04, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x01, 0x38, 0x42, 0x49, 0x4D, 0x04, 0x0C, 0x00, 0x00, 0x00, 0x00,
	0x09, 0x14, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0xA0, 0x00, 0x00, 0x00, 0x22, 0x00, 0x00, 0x01, 0xE0, 0x00, 0x00, 0x3F, 0xC0, 0x00, 0x00, 0x08, 0xF8, 0x00, 0x18, 0x00, 0x01, 0xFF, 0xD8, 0xFF, 0xED, 0x00, 0x0C, 0x41, 0x64, 0x6F, 0x62, 0x65, 0x5F, 0x43, 0x4D, 0x00, 0x01, 0xFF, 0xEE, 0x00, 0x0E,
	0x41, 0x64, 0x6F, 0x62, 0x65, 0x00, 0x64, 0x80, 0x00, 0x00, 0x00, 0x01, 0xFF, 0xDB, 0x00, 0x84, 0x00, 0x0C, 0x08, 0x08, 0x08, 0x09, 0x08, 0x0C, 0x09, 0x09, 0x0C, 0x11, 0x0B, 0x0A, 0x0B, 0x11, 0x15, 0x0F, 0x0C, 0x0C, 0x0F, 0x15, 0x18, 0x13, 0x13, 0x15, 0x13, 0x13, 0x18, 0x11, 0x0C, 0x0C, 0x0C, 0x0C,
	0x0C, 0x0C, 0x11, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x01, 0x0D, 0x0B, 0x0B, 0x0D, 0x0E, 0x0D, 0x10, 0x0E, 0x0E, 0x10, 0x14, 0x0E, 0x0E, 0x0E, 0x14, 0x14, 0x0E, 0x0E,
	0x0E, 0x0E, 0x14, 0x11, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x11, 0x11, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x11, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0xFF, 0xC0, 0x00, 0x11,
	0x08, 0x00, 0x22, 0x00, 0xA0, 0x03, 0x01, 0x22, 0x00, 0x02, 0x11, 0x01, 0x03, 0x11, 0x01, 0xFF, 0xDD, 0x00, 0x04, 0x00, 0x0A, 0xFF, 0xC4, 0x01, 0x3F, 0x00, 0x00, 0x01, 0x05, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x01, 0x02, 0x04, 0x05, 0x06, 0x07,
	0x08, 0x09, 0x0A, 0x0B, 0x01, 0x00, 0x01, 0x05, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B, 0x10, 0x00, 0x01, 0x04, 0x01, 0x03, 0x02, 0x04, 0x02, 0x05, 0x07, 0x06, 0x08, 0x05, 0x03, 0x0C, 0x33,
	0x01, 0x00, 0x02, 0x11, 0x03, 0x04, 0x21, 0x12, 0x31, 0x05, 0x41, 0x51, 0x61, 0x13, 0x22, 0x71, 0x81, 0x32, 0x06, 0x14, 0x91, 0xA1, 0xB1, 0x42, 0x23, 0x24, 0x15, 0x52, 0xC1, 0x62, 0x33, 0x34, 0x72, 0x82, 0xD1, 0x43, 0x07, 0x25, 0x92, 0x53, 0xF0, 0xE1, 0xF1, 0x63, 0x73, 0x35, 0x16, 0xA2, 0xB2, 0x83,
	0x26, 0x44, 0x93, 0x54, 0x64, 0x45, 0xC2, 0xA3, 0x74, 0x36, 0x17, 0xD2, 0x55, 0xE2, 0x65, 0xF2, 0xB3, 0x84, 0xC3, 0xD3, 0x75, 0xE3, 0xF3, 0x46, 0x27, 0x94, 0xA4, 0x85, 0xB4, 0x95, 0xC4, 0xD4, 0xE4, 0xF4, 0xA5, 0xB5, 0xC5, 0xD5, 0xE5, 0xF5, 0x56, 0x66, 0x76, 0x86, 0x96, 0xA6, 0xB6, 0xC6, 0xD6, 0xE6,
	0xF6, 0x37, 0x47, 0x57, 0x67, 0x77, 0x87, 0x97, 0xA7, 0xB7, 0xC7, 0xD7, 0xE7, 0xF7, 0x11, 0x00, 0x02, 0x02, 0x01, 0x02, 0x04, 0x04, 0x03, 0x04, 0x05, 0x06, 0x07, 0x07, 0x06, 0x05, 0x35, 0x01, 0x00, 0x02, 0x11, 0x03, 0x21, 0x31, 0x12, 0x04, 0x41, 0x51, 0x61, 0x71, 0x22, 0x13, 0x05, 0x32, 0x81, 0x91,
	0x14, 0xA1, 0xB1, 0x42, 0x23, 0xC1, 0x52, 0xD1, 0xF0, 0x33, 0x24, 0x62, 0xE1, 0x72, 0x82, 0x92, 0x43, 0x53, 0x15, 0x63, 0x73, 0x34, 0xF1, 0x25, 0x06, 0x16, 0xA2, 0xB2, 0x83, 0x07, 0x26, 0x35, 0xC2, 0xD2, 0x44, 0x93, 0x54, 0xA3, 0x17, 0x64, 0x45, 0x55, 0x36, 0x74, 0x65, 0xE2, 0xF2, 0xB3, 0x84, 0xC3,
	0xD3, 0x75, 0xE3, 0xF3, 0x46, 0x94, 0xA4, 0x85, 0xB4, 0x95, 0xC4, 0xD4, 0xE4, 0xF4, 0xA5, 0xB5, 0xC5, 0xD5, 0xE5, 0xF5, 0x56, 0x66, 0x76, 0x86, 0x96, 0xA6, 0xB6, 0xC6, 0xD6, 0xE6, 0xF6, 0x27, 0x37, 0x47, 0x57, 0x67, 0x77, 0x87, 0x97, 0xA7, 0xB7, 0xC7, 0xFF, 0xDA, 0x00, 0x0C, 0x03, 0x01, 0x00, 0x02,
	0x11, 0x03, 0x11, 0x00, 0x3F, 0x00, 0xF5, 0x54, 0x92, 0x49, 0x25, 0x29, 0x25, 0x9D, 0xD7, 0xBA, 0x93, 0xBA, 0x5F, 0x4A, 0xBF, 0x2E, 0xB6, 0x1B, 0x72, 0x00, 0x15, 0xE2, 0xD2, 0x35, 0x36, 0x5F, 0x6B, 0x85, 0x18, 0x94, 0xFF, 0x00, 0xD7, 0x32, 0x2C, 0xAF, 0xFB, 0x0A, 0x87, 0xD4, 0xAE, 0xB1, 0x95, 0xD5,
	0x7A, 0x28, 0x19, 0xE7, 0xFC, 0xA9, 0x81, 0x6D, 0x98, 0x5D, 0x45, 0xA6, 0x34, 0xBE, 0x93, 0xB5, 0xC7, 0xD9, 0xEC, 0x76, 0xF6, 0x6C, 0x7F, 0xE8, 0xFF, 0x00, 0x46, 0x92, 0x9E, 0x81, 0x25, 0xC7, 0xFD, 0x7D, 0xC9, 0xFA, 0xCB, 0xD3, 0x71, 0xE9, 0xCA, 0xE8, 0x39, 0xD6, 0x8C, 0x9C, 0xCC, 0x8A, 0xF1, 0x6A,
	0xC1, 0x35, 0xD0, 0xF6, 0x12, 0xE6, 0x5A, 0xF9, 0xAD, 0xD7, 0x55, 0xEA, 0xFA, 0x9F, 0xA1, 0xFC, 0xEB, 0x7F, 0xEB, 0x6B, 0x77, 0xEA, 0xE7, 0x5A, 0xA3, 0xAE, 0xF4, 0x4C, 0x4E, 0xAB, 0x4C, 0x34, 0x64, 0xD6, 0x0B, 0xD8, 0x27, 0xD9, 0x60, 0xF6, 0x5F, 0x57, 0xBB, 0xFD, 0x1D, 0xAD, 0x7B, 0x12, 0x53, 0xA6,
	0x92, 0xE1, 0x7E, 0xB7, 0xFD, 0x65, 0xEB, 0x95, 0x7D, 0x61, 0xE9, 0xDD, 0x2B, 0xA3, 0x5A, 0xEC, 0x5C, 0x47, 0x65, 0x53, 0x87, 0xD4, 0x33, 0x05, 0x6C, 0x7C, 0x5D, 0x95, 0xB6, 0xCA, 0xB1, 0xEA, 0x19, 0x35, 0xBD, 0xBE, 0xAD, 0x18, 0x8D, 0xFB, 0x4F, 0xE8, 0xF7, 0xD7, 0xFA, 0xC5, 0x5E, 0xB2, 0xB5, 0xF5,
	0xC1, 0x9F, 0x5A, 0xFA, 0x57, 0x4D, 0x1D, 0x4F, 0xA4, 0x75, 0x3B, 0xAC, 0xAF, 0x15, 0xAD, 0xFB, 0x75, 0x0F, 0xAA, 0x87, 0xBD, 0xD5, 0x37, 0xF9, 0xEC, 0xBC, 0x77, 0x7A, 0x3E, 0xDB, 0xEB, 0xFA, 0x76, 0xD6, 0xFF, 0x00, 0xD0, 0x7F, 0x53, 0xD2, 0xFD, 0x2A, 0x53, 0xD8, 0x24, 0xB0, 0x33, 0xBA, 0xDE, 0x2B,
	0x7E, 0xA9, 0xB7, 0xA9, 0xE2, 0xE5, 0x5D, 0x6B, 0x6F, 0xA6, 0xB1, 0x87, 0x75, 0x41, 0x8E, 0xC9, 0xB6, 0xEB, 0x36, 0xD7, 0x8F, 0x4B, 0x2B, 0xF4, 0xAD, 0xA7, 0xED, 0x57, 0x5D, 0xFA, 0x2B, 0x6B, 0xFB, 0x3F, 0xE8, 0xBF, 0x49, 0xFA, 0x35, 0x5F, 0xEC, 0x1F, 0x59, 0xF1, 0xFE, 0xAF, 0xDD, 0x93, 0x9B, 0xD6,
	0xAD, 0x1D, 0x51, 0x94, 0xBA, 0xF7, 0x1A, 0xA9, 0xC7, 0xF4, 0x58, 0xE6, 0xB1, 0xCF, 0xFB, 0x3B, 0x6A, 0x75, 0x2E, 0xF5, 0x6B, 0xDD, 0xEC, 0x7D, 0x8F, 0x7F, 0xA9, 0x67, 0xFC, 0x0A, 0x4A, 0x7A, 0x74, 0x97, 0x39, 0xF5, 0x1B, 0x27, 0xAA, 0x75, 0x0E, 0x85, 0x8F, 0xD5, 0xFA, 0x9E, 0x6B, 0xF2, 0xAE, 0xCD,
	0x61, 0x77, 0xA4, 0x59, 0x5B, 0x2B, 0xAE, 0x1C, 0xF6, 0xFE, 0x89, 0xB4, 0xD6, 0xCB, 0x3D, 0xCD, 0x0D, 0xDD, 0xEA, 0xD9, 0x62, 0x1E, 0x5B, 0x3A, 0xD7, 0xFC, 0xEA, 0xC7, 0xC0, 0xAB, 0xAB, 0xDF, 0x56, 0x16, 0x55, 0x17, 0x65, 0xBE, 0x91, 0x56, 0x39, 0x2D, 0x35, 0x3E, 0x8A, 0xC5, 0x15, 0x5E, 0xFA, 0x1C,
	0xFF, 0x00, 0x46, 0xCF, 0xB4, 0xFE, 0x7E, 0xFB, 0x7F, 0x47, 0xFC, 0xE7, 0xBD, 0x25, 0x3D, 0x3A, 0x4B, 0x82, 0xEB, 0xBD, 0x7F, 0xEB, 0x07, 0xD5, 0xAF, 0xAC, 0x75, 0xB4, 0xE4, 0x5B, 0xD5, 0x7A, 0x3D, 0x78, 0xC3, 0x2B, 0xA8, 0x50, 0xF6, 0x52, 0xDB, 0x6A, 0xA9, 0xD6, 0xFD, 0x97, 0xD7, 0xA5, 0xF4, 0xD7,
	0x4D, 0xB7, 0x7A, 0x4F, 0xD8, 0xED, 0x9E, 0xFF, 0x00, 0xCF, 0xF5, 0x7F, 0xD2, 0x53, 0xD3, 0xF5, 0x3B, 0x5F, 0x9B, 0xD1, 0x1D, 0x9D, 0xD2, 0xB3, 0x9D, 0x8F, 0xFA, 0x23, 0x93, 0x8F, 0x93, 0x43, 0x6B, 0xB0, 0x3D, 0xA1, 0x8E, 0x7B, 0x1A, 0xE6, 0x64, 0x57, 0x6B, 0x1D, 0x5B, 0xFF, 0x00, 0xED, 0xC4, 0x94,
	0xEB, 0x24, 0xB9, 0x4C, 0x73, 0xD6, 0xED, 0xFA, 0x98, 0xCE, 0xAE, 0xEE, 0xAF, 0x70, 0xCF, 0xB3, 0x10, 0x75, 0x00, 0xF1, 0x56, 0x3E, 0xC6, 0x93, 0x47, 0xAF, 0xF6, 0x5F, 0x47, 0xD0, 0xD9, 0xF6, 0x7D, 0xEE, 0xFF, 0x00, 0x8F, 0xFF, 0x00, 0x87, 0x47, 0xFA, 0x8D, 0x93, 0xD5, 0x3A, 0x8F, 0x41, 0xC7, 0xEA,
	0xFD, 0x4B, 0x35, 0xF9, 0x76, 0xE6, 0xB0, 0xBB, 0xD2, 0x35, 0xD7, 0x5D, 0x75, 0xED, 0x7B, 0xD9, 0xFA, 0x26, 0xD1, 0x5B, 0x1E, 0xEF, 0x6B, 0x7F, 0xC2, 0xD9, 0x62, 0x4A, 0x7A, 0x44, 0x97, 0x17, 0x6F, 0xF8, 0xCA, 0xC1, 0xDC, 0x0E, 0x2E, 0x05, 0xF7, 0x54, 0x78, 0xB1, 0xEE, 0x65, 0x72, 0x3C, 0x5B, 0x5B,
	0x9C, 0xF7, 0x7F, 0xDB, 0x9E, 0x9A, 0xDE, 0xFA, 0xBF, 0xF5, 0x87, 0x07, 0xAF, 0xE3, 0xDB, 0x76, 0x2B, 0x1F, 0x59, 0xA1, 0xE2, 0xBB, 0x59, 0x60, 0x12, 0x1C, 0x40, 0x78, 0xDA, 0xEA, 0xDD, 0x63, 0x1E, 0xDD, 0xAE, 0xFD, 0xE5, 0x2C, 0xF0, 0x65, 0x84, 0x78, 0xA5, 0x02, 0x23, 0xFC, 0x56, 0x47, 0x2E, 0x39,
	0x1E, 0x18, 0xC8, 0x12, 0xEB, 0x24, 0x98, 0x42, 0x45, 0x44, 0xBD, 0xFF, 0xD0, 0xF5, 0x54, 0x92, 0x4C, 0x41, 0x20, 0x80, 0x60, 0x9E, 0x0F, 0x82, 0x4A, 0x79, 0x0E, 0xBF, 0x99, 0x97, 0x9B, 0xF5, 0x9B, 0x17, 0x0F, 0x07, 0x01, 0xFD, 0x56, 0xAE, 0x85, 0x19, 0x99, 0x74, 0xD7, 0x65, 0x15, 0xED, 0xC9, 0xB9,
	0xB6, 0x57, 0xD3, 0x7D, 0x4F, 0xB5, 0xBA, 0xB7, 0x7E, 0x82, 0x9F, 0xB4, 0xE4, 0xFE, 0x8B, 0xFD, 0x2E, 0x3A, 0xCE, 0xC0, 0xCE, 0xCE, 0xE8, 0xFF, 0x00, 0x5F, 0x05, 0xD9, 0xDD, 0x3D, 0xFD, 0x2B, 0x0B, 0xEB, 0x3B, 0x05, 0x4E, 0x65, 0x96, 0xD3, 0x6B, 0x7E, 0xD9, 0x4F, 0xF3, 0x76, 0x35, 0xD8, 0xAE, 0xB7,
	0x67, 0xAC, 0xC7, 0xFA, 0x5B, 0x1F, 0xFC, 0xEE, 0x46, 0x47, 0xA8, 0xBA, 0x9E, 0x89, 0xF5, 0x79, 0xDD, 0x22, 0xFC, 0xAB, 0x87, 0x50, 0xC8, 0xCC, 0x19, 0xAF, 0x37, 0xE4, 0x37, 0x24, 0x54, 0x66, 0xF7, 0x06, 0x35, 0xD7, 0x31, 0xF4, 0xD3, 0x4D, 0x8C, 0x6F, 0xA7, 0x53, 0x6A, 0xAF, 0x1F, 0xF9, 0x8A, 0x99,
	0xFC, 0xDA, 0x1F, 0xD6, 0x3F, 0xAA, 0xB4, 0xFD, 0x62, 0xF4, 0x2B, 0xCB, 0xCD, 0xC8, 0xC7, 0xC7, 0xC7, 0x7B, 0x6E, 0xAE, 0xAC, 0x63, 0x5B, 0x08, 0xBD, 0xBB, 0x83, 0x32, 0x3D, 0x7B, 0x29, 0xB6, 0xE6, 0xB9, 0x8D, 0xB3, 0xDA, 0xD6, 0x3D, 0x25, 0x35, 0x3E, 0xBB, 0x9D, 0x7E, 0xAF, 0xFF, 0x00, 0xE9, 0xEF,
	0x0F, 0xF2, 0x5C, 0xB2, 0xA9, 0xEA, 0x34, 0x7D, 0x49, 0xEB, 0xBD, 0x63, 0x06, 0xF1, 0xB7, 0xA6, 0xE6, 0xD6, 0xEE, 0xAB, 0xD3, 0x18, 0x08, 0x6C, 0xDD, 0xA5, 0x79, 0x5D, 0x3E, 0x8D, 0x36, 0xFA, 0xB7, 0xDB, 0xB3, 0xEC, 0xF4, 0xB7, 0xE8, 0x33, 0xFE, 0x31, 0x6E, 0x75, 0x0F, 0xAA, 0xB7, 0xF5, 0x31, 0x88,
	0x33, 0x7A, 0xC6, 0x5B, 0xBE, 0xC3, 0x63, 0x32, 0x28, 0x35, 0xB3, 0x19, 0x87, 0xD7, 0xA8, 0xBD, 0xD5, 0xE4, 0xDB, 0xFA, 0xAB, 0x9A, 0xFD, 0xAD, 0xB3, 0x67, 0xA5, 0xFC, 0xC7, 0xFC, 0x12, 0xB7, 0x97, 0xF5, 0x7B, 0x0F, 0xA8, 0x3B, 0xA6, 0x5D, 0xD4, 0x5C, 0xEC, 0xAC, 0xAE, 0x93, 0x68, 0xBE, 0x9C, 0x82,
	0x1A, 0xD7, 0x39, 0xE1, 0xBB, 0x66, 0xC6, 0xB1, 0x9B, 0x36, 0xB9, 0xE2, 0xBB, 0xF6, 0x55, 0xE9, 0x7E, 0x9A, 0x9A, 0x92, 0x53, 0xC6, 0xF5, 0x8E, 0x9B, 0x77, 0x4D, 0x6F, 0xD5, 0x31, 0x96, 0x47, 0xED, 0x0C, 0xBE, 0xB3, 0x5E, 0x5F, 0x50, 0x70, 0x88, 0x39, 0x37, 0xB9, 0xAF, 0xBD, 0xBE, 0xD2, 0xE6, 0x6D,
	0xA7, 0xFA, 0x35, 0x3F, 0xF0, 0x55, 0x56, 0xBD, 0x14, 0x80, 0x64, 0x10, 0x0C, 0x8D, 0x67, 0xB8, 0x58, 0x3D, 0x67, 0xEA, 0x9F, 0xED, 0x9C, 0xDA, 0x72, 0xF2, 0xBA, 0x9E, 0x55, 0x7F, 0x63, 0xB9, 0xB9, 0x18, 0x34, 0xD2, 0x28, 0x6B, 0x2A, 0xB5, 0x9B, 0x76, 0xD9, 0xFA, 0x4C, 0x7B, 0x9F, 0x7F, 0xB9, 0xBB,
	0xBF, 0x4E, 0xF5, 0xB1, 0x4D, 0x19, 0x0C, 0xC3, 0x14, 0x59, 0x90, 0xEB, 0x6F, 0x0C, 0x2D, 0x39, 0x2E, 0x6B, 0x03, 0x8B, 0xBB, 0x5A, 0x6B, 0xAD, 0xAC, 0xA7, 0x77, 0xF6, 0x36, 0x24, 0xA7, 0x88, 0xFA, 0xB1, 0xD1, 0xA8, 0xC6, 0xFA, 0xE7, 0xD5, 0x7A, 0x50, 0xB6, 0xC7, 0xF4, 0xDE, 0x89, 0x63, 0x32, 0xFA,
	0x6E, 0x13, 0x8C, 0xD7, 0x55, 0xB9, 0x95, 0xEE, 0xB1, 0xE3, 0xF7, 0xBE, 0xCE, 0xC7, 0x59, 0x56, 0x2B, 0x1F, 0xBF, 0xD2, 0xF5, 0xAC, 0xB7, 0xFA, 0x47, 0xE9, 0x57, 0x65, 0xD6, 0x83, 0x8F, 0x46, 0xCF, 0x0D, 0x04, 0xB8, 0xE3, 0x5D, 0x00, 0x72, 0x4E, 0xC7, 0x2C, 0xAC, 0x0F, 0xAA, 0x2F, 0xC1, 0xEA, 0xB6,
	0xF5, 0x7A, 0xFA, 0xB6, 0x65, 0x99, 0xB9, 0x66, 0xBF, 0xB7, 0x1B, 0x1B, 0x8E, 0x6B, 0xB9, 0xB5, 0x00, 0xC6, 0x56, 0x69, 0x66, 0x35, 0x7E, 0x8F, 0xB0, 0x6C, 0xDF, 0x4B, 0xF7, 0xAE, 0x84, 0xA4, 0xA7, 0x9B, 0xFF, 0x00, 0x17, 0x2F, 0x6B, 0xFE, 0xA4, 0xF4, 0xA7, 0x34, 0xC8, 0x15, 0xBD, 0xB3, 0xE6, 0xDB,
	0x2C, 0x63, 0xBF, 0xE9, 0x35, 0x16, 0xEB, 0x6B, 0x77, 0xD7, 0xCC, 0x4A, 0x43, 0x87, 0xA9, 0x57, 0x4A, 0xC8, 0xB1, 0xED, 0xEE, 0x1A, 0xFB, 0xF1, 0x18, 0xC7, 0x7F, 0x69, 0xD5, 0x58, 0xAB, 0x63, 0xFD, 0x47, 0x77, 0x4C, 0xBE, 0xEB, 0x3E, 0xAF, 0xF5, 0x6C, 0xAE, 0x93, 0x46, 0x43, 0xFD, 0x4B, 0x30, 0xDA,
	0xDA, 0xAE, 0xA1, 0xAE, 0x3F, 0x48, 0xD1, 0x4E, 0x55, 0x6F, 0xF4, 0x77, 0x7F, 0xAF, 0xB1, 0x6A, 0xF4, 0x7E, 0x81, 0x8D, 0xD2, 0x9F, 0x7E, 0x47, 0xAD, 0x76, 0x66, 0x76, 0x59, 0x07, 0x27, 0x33, 0x25, 0xC1, 0xD6, 0x3C, 0x36, 0x76, 0x56, 0x36, 0x35, 0x95, 0x55, 0x4D, 0x7B, 0xBF, 0x45, 0x55, 0x55, 0xA4,
	0xA7, 0x29, 0xE2, 0xBB, 0x3F, 0xC6, 0x3B, 0xA9, 0xB1, 0xA1, 0xCC, 0x77, 0x43, 0x21, 0xEC, 0x70, 0x04, 0x16, 0xBB, 0x2B, 0x69, 0x6B, 0x81, 0xFD, 0xE5, 0x90, 0xF6, 0xBF, 0xEA, 0x3E, 0x65, 0xBD, 0x36, 0xFB, 0x4F, 0xFC, 0xD4, 0xEA, 0xC2, 0xD6, 0xE1, 0xDB, 0x64, 0xB8, 0x61, 0x64, 0x3D, 0xAF, 0x71, 0xC5,
	0x75, 0x90, 0xF7, 0xFD, 0x96, 0xFF, 0x00, 0xCC, 0xFF, 0x00, 0xB7, 0x3F, 0xEE, 0x55, 0xD7, 0x74, 0x3F, 0xF3, 0x5A, 0xFF, 0x00, 0xDB, 0x3F, 0xB6, 0xFF, 0x00, 0x6B, 0x65, 0x7D, 0xB8, 0xB3, 0xEC, 0xFF, 0x00, 0x43, 0x1F, 0xD2, 0xFB, 0x37, 0xA9, 0xF6, 0x8F, 0xB2, 0x7A, 0x5F, 0x66, 0xFD, 0xFF, 0x00, 0xF0,
	0xFE, 0xA7, 0xDA, 0x3F, 0xE1, 0x16, 0xA7, 0x54, 0xE9, 0x78, 0x7D, 0x57, 0x02, 0xFE, 0x9D, 0x9C, 0xC1, 0x66, 0x36, 0x43, 0x76, 0x3D, 0xBD, 0xFC, 0x5A, 0xF6, 0x9F, 0xCD, 0xB1, 0x8F, 0xF7, 0xD6, 0xEF, 0xDF, 0x49, 0x4E, 0x26, 0x21, 0x03, 0xFC, 0x5B, 0xD0, 0x4F, 0xFE, 0x52, 0xB7, 0xFF, 0x00, 0x6D, 0x42,
	0x7F, 0xF1, 0x74, 0x7F, 0xEC, 0x23, 0xA5, 0xC7, 0x3E, 0x93, 0xFF, 0x00, 0xF3, 0xE5, 0x8A, 0xED, 0xDF, 0x57, 0x8B, 0xFA, 0x16, 0x3F, 0x43, 0xA7, 0x3A, 0xFC, 0x5C, 0x6A, 0x68, 0x6E, 0x2D, 0xB6, 0x54, 0x2B, 0xF5, 0x6C, 0xA9, 0xB5, 0xFD, 0x9B, 0x61, 0x7D, 0xD5, 0x5C, 0xDA, 0xB7, 0xB7, 0xDD, 0xEA, 0x54,
	0xCF, 0x51, 0x4B, 0xEA, 0xFF, 0x00, 0x40, 0xFD, 0x83, 0x8C, 0x30, 0x69, 0xCD, 0xBF, 0x27, 0x0A, 0xA6, 0x86, 0xE3, 0xD3, 0x78, 0xA8, 0x9A, 0xF5, 0x73, 0xDF, 0xB6, 0xEA, 0x2A, 0xA2, 0xCB, 0x37, 0x6E, 0xFF, 0x00, 0x0A, 0x92, 0x9E, 0x6B, 0x17, 0xFC, 0x59, 0x38, 0x50, 0xC6, 0xE4, 0xF5, 0x27, 0x7A, 0x82,
	0x09, 0x14, 0xD4, 0xD0, 0xC0, 0x67, 0x77, 0xF8, 0x52, 0xF7, 0x3D, 0x60, 0xF5, 0x6F, 0xF1, 0x82, 0xFB, 0x1D, 0x50, 0xFA, 0xAC, 0xD3, 0xD1, 0xD8, 0xD3, 0x60, 0xCC, 0x61, 0xA7, 0x1F, 0xF4, 0x8E, 0x96, 0x32, 0x97, 0x6D, 0x8B, 0xB6, 0xBA, 0xBD, 0x96, 0x7F, 0xDB, 0x8B, 0xD6, 0x16, 0x76, 0x5F, 0xD5, 0xCE,
	0x81, 0x9B, 0x69, 0xBF, 0x2F, 0xA6, 0xE2, 0xDF, 0x71, 0x32, 0x6C, 0xB2, 0x96, 0x39, 0xC4, 0xFF, 0x00, 0x29, 0xE5, 0xBB, 0x9C, 0xA7, 0x97, 0x31, 0x39, 0x9F, 0xD6, 0x1E, 0x2E, 0xC1, 0x8E, 0x38, 0xA3, 0x1F, 0x90, 0x70, 0xF8, 0xBC, 0xB7, 0xF8, 0xB0, 0xEA, 0xDD, 0x43, 0xAA, 0x59, 0xD5, 0xAD, 0xCF, 0xCC,
	0xB3, 0x36, 0xC6, 0x3A, 0x80, 0x0B, 0xDD, 0x2D, 0x6C, 0x8B, 0x65, 0xB5, 0x56, 0xCD, 0xB5, 0x55, 0xFC, 0xAD, 0x8D, 0x5D, 0xDA, 0x0E, 0x36, 0x26, 0x2E, 0x25, 0x42, 0x9C, 0x5A, 0x6B, 0xC7, 0xA8, 0x71, 0x5D, 0x4D, 0x0C, 0x68, 0xFE, 0xCB, 0x03, 0x5A, 0x8A, 0x54, 0x52, 0x20, 0x92, 0x40, 0xA5, 0xE0, 0x50,
	0x7F, 0xFF, 0xD1, 0xF5, 0x54, 0x97, 0xCA, 0xA9, 0x24, 0xA7, 0xEA, 0xA4, 0x97, 0xCA, 0xA9, 0x24, 0xA7, 0xEA, 0xA4, 0x97, 0xCA, 0xA9, 0x24, 0xA7, 0xEA, 0xA4, 0x97, 0xCA, 0xA9, 0x24, 0xA7, 0xEA, 0xA4, 0x97, 0xCA, 0xA9, 0x24, 0xA7, 0xEA, 0xA4, 0x97, 0xCA, 0xA9, 0x24, 0xA7, 0xEA, 0xA4, 0x97, 0xCA, 0xA9,
	0x24, 0xA7, 0xEA, 0xA4, 0x97, 0xCA, 0xA9, 0x24, 0xA7, 0xEA, 0xA4, 0x97, 0xCA, 0xA9, 0x24, 0xA7, 0xEA, 0xA4, 0xC5, 0x7C, 0xAC, 0x92, 0x4A, 0x7F, 0xFF, 0xD9, 0x38, 0x42, 0x49, 0x4D, 0x04, 0x21, 0x00, 0x00, 0x00, 0x00, 0x00, 0x55, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00, 0x00, 0x0F, 0x00, 0x41, 0x00,
	0x64, 0x00, 0x6F, 0x00, 0x62, 0x00, 0x65, 0x00, 0x20, 0x00, 0x50, 0x00, 0x68, 0x00, 0x6F, 0x00, 0x74, 0x00, 0x6F, 0x00, 0x73, 0x00, 0x68, 0x00, 0x6F, 0x00, 0x70, 0x00, 0x00, 0x00, 0x13, 0x00, 0x41, 0x00, 0x64, 0x00, 0x6F, 0x00, 0x62, 0x00, 0x65, 0x00, 0x20, 0x00, 0x50, 0x00, 0x68, 0x00, 0x6F, 0x00,
	0x74, 0x00, 0x6F, 0x00, 0x73, 0x00, 0x68, 0x00, 0x6F, 0x00, 0x70, 0x00, 0x20, 0x00, 0x43, 0x00, 0x53, 0x00, 0x36, 0x00, 0x00, 0x00, 0x01, 0x00, 0x38, 0x42, 0x49, 0x4D, 0x04, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x08, 0x01, 0x01, 0x00, 0x01, 0x01, 0x00, 0xFF, 0xE1, 0x0C, 0xDE, 0x68, 0x74,
	0x74, 0x70, 0x3A, 0x2F, 0x2F, 0x6E, 0x73, 0x2E, 0x61, 0x64, 0x6F, 0x62, 0x65, 0x2E, 0x63, 0x6F, 0x6D, 0x2F, 0x78, 0x61, 0x70, 0x2F, 0x31, 0x2E, 0x30, 0x2F, 0x00, 0x3C, 0x3F, 0x78, 0x70, 0x61, 0x63, 0x6B, 0x65, 0x74, 0x20, 0x62, 0x65, 0x67, 0x69, 0x6E, 0x3D, 0x22, 0xEF, 0xBB, 0xBF, 0x22, 0x20, 0x69,
	0x64, 0x3D, 0x22, 0x57, 0x35, 0x4D, 0x30, 0x4D, 0x70, 0x43, 0x65, 0x68, 0x69, 0x48, 0x7A, 0x72, 0x65, 0x53, 0x7A, 0x4E, 0x54, 0x63, 0x7A, 0x6B, 0x63, 0x39, 0x64, 0x22, 0x3F, 0x3E, 0x20, 0x3C, 0x78, 0x3A, 0x78, 0x6D, 0x70, 0x6D, 0x65, 0x74, 0x61, 0x20, 0x78, 0x6D, 0x6C, 0x6E, 0x73, 0x3A, 0x78, 0x3D,
	0x22, 0x61, 0x64, 0x6F, 0x62, 0x65, 0x3A, 0x6E, 0x73, 0x3A, 0x6D, 0x65, 0x74, 0x61, 0x2F, 0x22, 0x20, 0x78, 0x3A, 0x78, 0x6D, 0x70, 0x74, 0x6B, 0x3D, 0x22, 0x41, 0x64, 0x6F, 0x62, 0x65, 0x20, 0x58, 0x4D, 0x50, 0x20, 0x43, 0x6F, 0x72, 0x65, 0x20, 0x35, 0x2E, 0x33, 0x2D, 0x63, 0x30, 0x31, 0x31, 0x20,
	0x36, 0x36, 0x2E, 0x31, 0x34, 0x35, 0x36, 0x36, 0x31, 0x2C, 0x20, 0x32, 0x30, 0x31, 0x32, 0x2F, 0x30, 0x32, 0x2F, 0x30, 0x36, 0x2D, 0x31, 0x34, 0x3A, 0x35, 0x36, 0x3A, 0x32, 0x37, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x22, 0x3E, 0x20, 0x3C, 0x72, 0x64, 0x66, 0x3A, 0x52, 0x44, 0x46, 0x20,
	0x78, 0x6D, 0x6C, 0x6E, 0x73, 0x3A, 0x72, 0x64, 0x66, 0x3D, 0x22, 0x68, 0x74, 0x74, 0x70, 0x3A, 0x2F, 0x2F, 0x77, 0x77, 0x77, 0x2E, 0x77, 0x33, 0x2E, 0x6F, 0x72, 0x67, 0x2F, 0x31, 0x39, 0x39, 0x39, 0x2F, 0x30, 0x32, 0x2F, 0x32, 0x32, 0x2D, 0x72, 0x64, 0x66, 0x2D, 0x73, 0x79, 0x6E, 0x74, 0x61, 0x78,
	0x2D, 0x6E, 0x73, 0x23, 0x22, 0x3E, 0x20, 0x3C, 0x72, 0x64, 0x66, 0x3A, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6F, 0x6E, 0x20, 0x72, 0x64, 0x66, 0x3A, 0x61, 0x62, 0x6F, 0x75, 0x74, 0x3D, 0x22, 0x22, 0x20, 0x78, 0x6D, 0x6C, 0x6E, 0x73, 0x3A, 0x78, 0x6D, 0x70, 0x4D, 0x4D, 0x3D, 0x22,
	0x68, 0x74, 0x74, 0x70, 0x3A, 0x2F, 0x2F, 0x6E, 0x73, 0x2E, 0x61, 0x64, 0x6F, 0x62, 0x65, 0x2E, 0x63, 0x6F, 0x6D, 0x2F, 0x78, 0x61, 0x70, 0x2F, 0x31, 0x2E, 0x30, 0x2F, 0x6D, 0x6D, 0x2F, 0x22, 0x20, 0x78, 0x6D, 0x6C, 0x6E, 0x73, 0x3A, 0x73, 0x74, 0x45, 0x76, 0x74, 0x3D, 0x22, 0x68, 0x74, 0x74, 0x70,
	0x3A, 0x2F, 0x2F, 0x6E, 0x73, 0x2E, 0x61, 0x64, 0x6F, 0x62, 0x65, 0x2E, 0x63, 0x6F, 0x6D, 0x2F, 0x78, 0x61, 0x70, 0x2F, 0x31, 0x2E, 0x30, 0x2F, 0x73, 0x54, 0x79, 0x70, 0x65, 0x2F, 0x52, 0x65, 0x73, 0x6F, 0x75, 0x72, 0x63, 0x65, 0x45, 0x76, 0x65, 0x6E, 0x74, 0x23, 0x22, 0x20, 0x78, 0x6D, 0x6C, 0x6E,
	0x73, 0x3A, 0x64, 0x63, 0x3D, 0x22, 0x68, 0x74, 0x74, 0x70, 0x3A, 0x2F, 0x2F, 0x70, 0x75, 0x72, 0x6C, 0x2E, 0x6F, 0x72, 0x67, 0x2F, 0x64, 0x63, 0x2F, 0x65, 0x6C, 0x65, 0x6D, 0x65, 0x6E, 0x74, 0x73, 0x2F, 0x31, 0x2E, 0x31, 0x2F, 0x22, 0x20, 0x78, 0x6D, 0x6C, 0x6E, 0x73, 0x3A, 0x70, 0x68, 0x6F, 0x74,
	0x6F, 0x73, 0x68, 0x6F, 0x70, 0x3D, 0x22, 0x68, 0x74, 0x74, 0x70, 0x3A, 0x2F, 0x2F, 0x6E, 0x73, 0x2E, 0x61, 0x64, 0x6F, 0x62, 0x65, 0x2E, 0x63, 0x6F, 0x6D, 0x2F, 0x70, 0x68, 0x6F, 0x74, 0x6F, 0x73, 0x68, 0x6F, 0x70, 0x2F, 0x31, 0x2E, 0x30, 0x2F, 0x22, 0x20, 0x78, 0x6D, 0x6C, 0x6E, 0x73, 0x3A, 0x78,
	0x6D, 0x70, 0x3D, 0x22, 0x68, 0x74, 0x74, 0x70, 0x3A, 0x2F, 0x2F, 0x6E, 0x73, 0x2E, 0x61, 0x64, 0x6F, 0x62, 0x65, 0x2E, 0x63, 0x6F, 0x6D, 0x2F, 0x78, 0x61, 0x70, 0x2F, 0x31, 0x2E, 0x30, 0x2F, 0x22, 0x20, 0x78, 0x6D, 0x70, 0x4D, 0x4D, 0x3A, 0x44, 0x6F, 0x63, 0x75, 0x6D, 0x65, 0x6E, 0x74, 0x49, 0x44,
	0x3D, 0x22, 0x43, 0x45, 0x43, 0x39, 0x41, 0x46, 0x39, 0x44, 0x30, 0x32, 0x32, 0x46, 0x41, 0x31, 0x32, 0x43, 0x42, 0x41, 0x44, 0x46, 0x38, 0x37, 0x37, 0x45, 0x33, 0x38, 0x43, 0x43, 0x41, 0x39, 0x42, 0x35, 0x22, 0x20, 0x78, 0x6D, 0x70, 0x4D, 0x4D, 0x3A, 0x49, 0x6E, 0x73, 0x74, 0x61, 0x6E, 0x63, 0x65,
	0x49, 0x44, 0x3D, 0x22, 0x78, 0x6D, 0x70, 0x2E, 0x69, 0x69, 0x64, 0x3A, 0x44, 0x32, 0x45, 0x37, 0x46, 0x38, 0x43, 0x43, 0x32, 0x41, 0x44, 0x41, 0x45, 0x34, 0x31, 0x31, 0x38, 0x30, 0x45, 0x34, 0x43, 0x38, 0x45, 0x42, 0x38, 0x37, 0x42, 0x45, 0x45, 0x36, 0x45, 0x33, 0x22, 0x20, 0x78, 0x6D, 0x70, 0x4D,
	0x4D, 0x3A, 0x4F, 0x72, 0x69, 0x67, 0x69, 0x6E, 0x61, 0x6C, 0x44, 0x6F, 0x63, 0x75, 0x6D, 0x65, 0x6E, 0x74, 0x49, 0x44, 0x3D, 0x22, 0x43, 0x45, 0x43, 0x39, 0x41, 0x46, 0x39, 0x44, 0x30, 0x32, 0x32, 0x46, 0x41, 0x31, 0x32, 0x43, 0x42, 0x41, 0x44, 0x46, 0x38, 0x37, 0x37, 0x45, 0x33, 0x38, 0x43, 0x43,
	0x41, 0x39, 0x42, 0x35, 0x22, 0x20, 0x64, 0x63, 0x3A, 0x66, 0x6F, 0x72, 0x6D, 0x61, 0x74, 0x3D, 0x22, 0x69, 0x6D, 0x61, 0x67, 0x65, 0x2F, 0x6A, 0x70, 0x65, 0x67, 0x22, 0x20, 0x70, 0x68, 0x6F, 0x74, 0x6F, 0x73, 0x68, 0x6F, 0x70, 0x3A, 0x43, 0x6F, 0x6C, 0x6F, 0x72, 0x4D, 0x6F, 0x64, 0x65, 0x3D, 0x22,
	0x33, 0x22, 0x20, 0x70, 0x68, 0x6F, 0x74, 0x6F, 0x73, 0x68, 0x6F, 0x70, 0x3A, 0x49, 0x43, 0x43, 0x50, 0x72, 0x6F, 0x66, 0x69, 0x6C, 0x65, 0x3D, 0x22, 0x73, 0x52, 0x47, 0x42, 0x20, 0x49, 0x45, 0x43, 0x36, 0x31, 0x39, 0x36, 0x36, 0x2D, 0x32, 0x2E, 0x31, 0x22, 0x20, 0x78, 0x6D, 0x70, 0x3A, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x44, 0x61, 0x74, 0x65, 0x3D, 0x22, 0x32, 0x30, 0x31, 0x35, 0x2D, 0x30, 0x34, 0x2D, 0x30, 0x33, 0x54, 0x31, 0x38, 0x3A, 0x34, 0x31, 0x3A, 0x34, 0x30, 0x2B, 0x30, 0x31, 0x3A, 0x30, 0x30, 0x22, 0x20, 0x78, 0x6D, 0x70, 0x3A, 0x4D, 0x6F, 0x64, 0x69, 0x66, 0x79, 0x44, 0x61, 0x74,
	0x65, 0x3D, 0x22, 0x32, 0x30, 0x31, 0x35, 0x2D, 0x30, 0x34, 0x2D, 0x30, 0x33, 0x54, 0x31, 0x39, 0x3A, 0x30, 0x37, 0x3A, 0x32, 0x30, 0x2B, 0x30, 0x31, 0x3A, 0x30, 0x30, 0x22, 0x20, 0x78, 0x6D, 0x70, 0x3A, 0x4D, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x44, 0x61, 0x74, 0x65, 0x3D, 0x22, 0x32, 0x30,
	0x31, 0x35, 0x2D, 0x30, 0x34, 0x2D, 0x30, 0x33, 0x54, 0x31, 0x39, 0x3A, 0x30, 0x37, 0x3A, 0x32, 0x30, 0x2B, 0x30, 0x31, 0x3A, 0x30, 0x30, 0x22, 0x3E, 0x20, 0x3C, 0x78, 0x6D, 0x70, 0x4D, 0x4D, 0x3A, 0x48, 0x69, 0x73, 0x74, 0x6F, 0x72, 0x79, 0x3E, 0x20, 0x3C, 0x72, 0x64, 0x66, 0x3A, 0x53, 0x65, 0x71,
	0x3E, 0x20, 0x3C, 0x72, 0x64, 0x66, 0x3A, 0x6C, 0x69, 0x20, 0x73, 0x74, 0x45, 0x76, 0x74, 0x3A, 0x61, 0x63, 0x74, 0x69, 0x6F, 0x6E, 0x3D, 0x22, 0x73, 0x61, 0x76, 0x65, 0x64, 0x22, 0x20, 0x73, 0x74, 0x45, 0x76, 0x74, 0x3A, 0x69, 0x6E, 0x73, 0x74, 0x61, 0x6E, 0x63, 0x65, 0x49, 0x44, 0x3D, 0x22, 0x78,
	0x6D, 0x70, 0x2E, 0x69, 0x69, 0x64, 0x3A, 0x44, 0x32, 0x45, 0x37, 0x46, 0x38, 0x43, 0x43, 0x32, 0x41, 0x44, 0x41, 0x45, 0x34, 0x31, 0x31, 0x38, 0x30, 0x45, 0x34, 0x43, 0x38, 0x45, 0x42, 0x38, 0x37, 0x42, 0x45, 0x45, 0x36, 0x45, 0x33, 0x22, 0x20, 0x73, 0x74, 0x45, 0x76, 0x74, 0x3A, 0x77, 0x68, 0x65,
	0x6E, 0x3D, 0x22, 0x32, 0x30, 0x31, 0x35, 0x2D, 0x30, 0x34, 0x2D, 0x30, 0x33, 0x54, 0x31, 0x39, 0x3A, 0x30, 0x37, 0x3A, 0x32, 0x30, 0x2B, 0x30, 0x31, 0x3A, 0x30, 0x30, 0x22, 0x20, 0x73, 0x74, 0x45, 0x76, 0x74, 0x3A, 0x73, 0x6F, 0x66, 0x74, 0x77, 0x61, 0x72, 0x65, 0x41, 0x67, 0x65, 0x6E, 0x74, 0x3D,
	0x22, 0x41, 0x64, 0x6F, 0x62, 0x65, 0x20, 0x50, 0x68, 0x6F, 0x74, 0x6F, 0x73, 0x68, 0x6F, 0x70, 0x20, 0x43, 0x53, 0x36, 0x20, 0x28, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x29, 0x22, 0x20, 0x73, 0x74, 0x45, 0x76, 0x74, 0x3A, 0x63, 0x68, 0x61, 0x6E, 0x67, 0x65, 0x64, 0x3D, 0x22, 0x2F, 0x22, 0x2F,
	0x3E, 0x20, 0x3C, 0x2F, 0x72, 0x64, 0x66, 0x3A, 0x53, 0x65, 0x71, 0x3E, 0x20, 0x3C, 0x2F, 0x78, 0x6D, 0x70, 0x4D, 0x4D, 0x3A, 0x48, 0x69, 0x73, 0x74, 0x6F, 0x72, 0x79, 0x3E, 0x20, 0x3C, 0x2F, 0x72, 0x64, 0x66, 0x3A, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6F, 0x6E, 0x3E, 0x20, 0x3C,
	0x2F, 0x72, 0x64, 0x66, 0x3A, 0x52, 0x44, 0x46, 0x3E, 0x20, 0x3C, 0x2F, 0x78, 0x3A, 0x78, 0x6D, 0x70, 0x6D, 0x65, 0x74, 0x61, 0x3E, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x3C, 0x3F, 0x78, 0x70, 0x61, 0x63, 0x6B, 0x65, 0x74, 0x20, 0x65, 0x6E, 0x64, 0x3D, 0x22, 0x77, 0x22, 0x3F, 0x3E, 0xFF, 0xE2, 0x0C, 0x58, 0x49, 0x43, 0x43, 0x5F, 0x50, 0x52,
	0x4F, 0x46, 0x49, 0x4C, 0x45, 0x00, 0x01, 0x01, 0x00, 0x00, 0x0C, 0x48, 0x4C, 0x69, 0x6E, 0x6F, 0x02, 0x10, 0x00, 0x00, 0x6D, 0x6E, 0x74, 0x72, 0x52, 0x47, 0x42, 0x20, 0x58, 0x59, 0x5A, 0x20, 0x07, 0xCE, 0x00, 0x02, 0x00, 0x09, 0x00, 0x06, 0x00, 0x31, 0x00, 0x00, 0x61, 0x63, 0x73, 0x70, 0x4D, 0x53,
	0x46, 0x54, 0x00, 0x00, 0x00, 0x00, 0x49, 0x45, 0x43, 0x20, 0x73, 0x52, 0x47, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF6, 0xD6, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0xD3, 0x2D, 0x48, 0x50, 0x20, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x63, 0x70, 0x72, 0x74, 0x00, 0x00, 0x01, 0x50, 0x00, 0x00,
	0x00, 0x33, 0x64, 0x65, 0x73, 0x63, 0x00, 0x00, 0x01, 0x84, 0x00, 0x00, 0x00, 0x6C, 0x77, 0x74, 0x70, 0x74, 0x00, 0x00, 0x01, 0xF0, 0x00, 0x00, 0x00, 0x14, 0x62, 0x6B, 0x70, 0x74, 0x00, 0x00, 0x02, 0x04, 0x00, 0x00, 0x00, 0x14, 0x72, 0x58, 0x59, 0x5A, 0x00, 0x00, 0x02, 0x18, 0x00, 0x00, 0x00, 0x14,
	0x67, 0x58, 0x59, 0x5A, 0x00, 0x00, 0x02, 0x2C, 0x00, 0x00, 0x00, 0x14, 0x62, 0x58, 0x59, 0x5A, 0x00, 0x00, 0x02, 0x40, 0x00, 0x00, 0x00, 0x14, 0x64, 0x6D, 0x6E, 0x64, 0x00, 0x00, 0x02, 0x54, 0x00, 0x00, 0x00, 0x70, 0x64, 0x6D, 0x64, 0x64, 0x00, 0x00, 0x02, 0xC4, 0x00, 0x00, 0x00, 0x88, 0x76, 0x75,
	0x65, 0x64, 0x00, 0x00, 0x03, 0x4C, 0x00, 0x00, 0x00, 0x86, 0x76, 0x69, 0x65, 0x77, 0x00, 0x00, 0x03, 0xD4, 0x00, 0x00, 0x00, 0x24, 0x6C, 0x75, 0x6D, 0x69, 0x00, 0x00, 0x03, 0xF8, 0x00, 0x00, 0x00, 0x14, 0x6D, 0x65, 0x61, 0x73, 0x00, 0x00, 0x04, 0x0C, 0x00, 0x00, 0x00, 0x24, 0x74, 0x65, 0x63, 0x68,
	0x00, 0x00, 0x04, 0x30, 0x00, 0x00, 0x00, 0x0C, 0x72, 0x54, 0x52, 0x43, 0x00, 0x00, 0x04, 0x3C, 0x00, 0x00, 0x08, 0x0C, 0x67, 0x54, 0x52, 0x43, 0x00, 0x00, 0x04, 0x3C, 0x00, 0x00, 0x08, 0x0C, 0x62, 0x54, 0x52, 0x43, 0x00, 0x00, 0x04, 0x3C, 0x00, 0x00, 0x08, 0x0C, 0x74, 0x65, 0x78, 0x74, 0x00, 0x00,
	0x00, 0x00, 0x43, 0x6F, 0x70, 0x79, 0x72, 0x69, 0x67, 0x68, 0x74, 0x20, 0x28, 0x63, 0x29, 0x20, 0x31, 0x39, 0x39, 0x38, 0x20, 0x48, 0x65, 0x77, 0x6C, 0x65, 0x74, 0x74, 0x2D, 0x50, 0x61, 0x63, 0x6B, 0x61, 0x72, 0x64, 0x20, 0x43, 0x6F, 0x6D, 0x70, 0x61, 0x6E, 0x79, 0x00, 0x00, 0x64, 0x65, 0x73, 0x63,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x73, 0x52, 0x47, 0x42, 0x20, 0x49, 0x45, 0x43, 0x36, 0x31, 0x39, 0x36, 0x36, 0x2D, 0x32, 0x2E, 0x31, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x73, 0x52, 0x47, 0x42, 0x20, 0x49, 0x45, 0x43, 0x36, 0x31, 0x39, 0x36, 0x36,
	0x2D, 0x32, 0x2E, 0x31, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x58, 0x59, 0x5A, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF3, 0x51, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x16, 0xCC, 0x58, 0x59, 0x5A, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x58, 0x59, 0x5A, 0x20, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x6F, 0xA2, 0x00, 0x00, 0x38, 0xF5, 0x00, 0x00, 0x03, 0x90, 0x58, 0x59, 0x5A, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x62, 0x99, 0x00, 0x00, 0xB7, 0x85, 0x00, 0x00, 0x18, 0xDA, 0x58, 0x59, 0x5A, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0xA0, 0x00, 0x00, 0x0F, 0x84,
	0x00, 0x00, 0xB6, 0xCF, 0x64, 0x65, 0x73, 0x63, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x16, 0x49, 0x45, 0x43, 0x20, 0x68, 0x74, 0x74, 0x70, 0x3A, 0x2F, 0x2F, 0x77, 0x77, 0x77, 0x2E, 0x69, 0x65, 0x63, 0x2E, 0x63, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x16, 0x49,
	0x45, 0x43, 0x20, 0x68, 0x74, 0x74, 0x70, 0x3A, 0x2F, 0x2F, 0x77, 0x77, 0x77, 0x2E, 0x69, 0x65, 0x63, 0x2E, 0x63, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x64, 0x65, 0x73, 0x63, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2E, 0x49, 0x45, 0x43, 0x20, 0x36, 0x31, 0x39, 0x36, 0x36, 0x2D, 0x32, 0x2E, 0x31, 0x20, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6C, 0x74, 0x20,
	0x52, 0x47, 0x42, 0x20, 0x63, 0x6F, 0x6C, 0x6F, 0x75, 0x72, 0x20, 0x73, 0x70, 0x61, 0x63, 0x65, 0x20, 0x2D, 0x20, 0x73, 0x52, 0x47, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2E, 0x49, 0x45, 0x43, 0x20, 0x36, 0x31, 0x39, 0x36, 0x36, 0x2D, 0x32, 0x2E, 0x31, 0x20, 0x44,
	0x65, 0x66, 0x61, 0x75, 0x6C, 0x74, 0x20, 0x52, 0x47, 0x42, 0x20, 0x63, 0x6F, 0x6C, 0x6F, 0x75, 0x72, 0x20, 0x73, 0x70, 0x61, 0x63, 0x65, 0x20, 0x2D, 0x20, 0x73, 0x52, 0x47, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x64, 0x65, 0x73, 0x63, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2C, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6E, 0x63, 0x65, 0x20, 0x56, 0x69, 0x65, 0x77, 0x69, 0x6E, 0x67, 0x20, 0x43, 0x6F, 0x6E, 0x64, 0x69, 0x74, 0x69, 0x6F, 0x6E, 0x20, 0x69, 0x6E, 0x20, 0x49, 0x45, 0x43, 0x36, 0x31,
	0x39, 0x36, 0x36, 0x2D, 0x32, 0x2E, 0x31, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2C, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6E, 0x63, 0x65, 0x20, 0x56, 0x69, 0x65, 0x77, 0x69, 0x6E, 0x67, 0x20, 0x43, 0x6F, 0x6E, 0x64, 0x69, 0x74, 0x69, 0x6F, 0x6E, 0x20, 0x69, 0x6E, 0x20,
	0x49, 0x45, 0x43, 0x36, 0x31, 0x39, 0x36, 0x36, 0x2D, 0x32, 0x2E, 0x31, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x76, 0x69, 0x65, 0x77, 0x00, 0x00, 0x00, 0x00, 0x00, 0x13, 0xA4, 0xFE,
	0x00, 0x14, 0x5F, 0x2E, 0x00, 0x10, 0xCF, 0x14, 0x00, 0x03, 0xED, 0xCC, 0x00, 0x04, 0x13, 0x0B, 0x00, 0x03, 0x5C, 0x9E, 0x00, 0x00, 0x00, 0x01, 0x58, 0x59, 0x5A, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4C, 0x09, 0x56, 0x00, 0x50, 0x00, 0x00, 0x00, 0x57, 0x1F, 0xE7, 0x6D, 0x65, 0x61, 0x73, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x8F, 0x00, 0x00, 0x00, 0x02, 0x73, 0x69, 0x67, 0x20, 0x00, 0x00, 0x00, 0x00, 0x43, 0x52, 0x54, 0x20, 0x63, 0x75, 0x72, 0x76, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x0A, 0x00, 0x0F, 0x00, 0x14, 0x00, 0x19, 0x00, 0x1E, 0x00, 0x23, 0x00, 0x28, 0x00, 0x2D, 0x00, 0x32, 0x00, 0x37, 0x00, 0x3B, 0x00, 0x40, 0x00, 0x45, 0x00, 0x4A, 0x00, 0x4F, 0x00, 0x54, 0x00, 0x59, 0x00, 0x5E, 0x00, 0x63, 0x00, 0x68, 0x00, 0x6D,
	0x00, 0x72, 0x00, 0x77, 0x00, 0x7C, 0x00, 0x81, 0x00, 0x86, 0x00, 0x8B, 0x00, 0x90, 0x00, 0x95, 0x00, 0x9A, 0x00, 0x9F, 0x00, 0xA4, 0x00, 0xA9, 0x00, 0xAE, 0x00, 0xB2, 0x00, 0xB7, 0x00, 0xBC, 0x00, 0xC1, 0x00, 0xC6, 0x00, 0xCB, 0x00, 0xD0, 0x00, 0xD5, 0x00, 0xDB, 0x00, 0xE0, 0x00, 0xE5, 0x00, 0xEB,
	0x00, 0xF0, 0x00, 0xF6, 0x00, 0xFB, 0x01, 0x01, 0x01, 0x07, 0x01, 0x0D, 0x01, 0x13, 0x01, 0x19, 0x01, 0x1F, 0x01, 0x25, 0x01, 0x2B, 0x01, 0x32, 0x01, 0x38, 0x01, 0x3E, 0x01, 0x45, 0x01, 0x4C, 0x01, 0x52, 0x01, 0x59, 0x01, 0x60, 0x01, 0x67, 0x01, 0x6E, 0x01, 0x75, 0x01, 0x7C, 0x01, 0x83, 0x01, 0x8B,
	0x01, 0x92, 0x01, 0x9A, 0x01, 0xA1, 0x01, 0xA9, 0x01, 0xB1, 0x01, 0xB9, 0x01, 0xC1, 0x01, 0xC9, 0x01, 0xD1, 0x01, 0xD9, 0x01, 0xE1, 0x01, 0xE9, 0x01, 0xF2, 0x01, 0xFA, 0x02, 0x03, 0x02, 0x0C, 0x02, 0x14, 0x02, 0x1D, 0x02, 0x26, 0x02, 0x2F, 0x02, 0x38, 0x02, 0x41, 0x02, 0x4B, 0x02, 0x54, 0x02, 0x5D,
	0x02, 0x67, 0x02, 0x71, 0x02, 0x7A, 0x02, 0x84, 0x02, 0x8E, 0x02, 0x98, 0x02, 0xA2, 0x02, 0xAC, 0x02, 0xB6, 0x02, 0xC1, 0x02, 0xCB, 0x02, 0xD5, 0x02, 0xE0, 0x02, 0xEB, 0x02, 0xF5, 0x03, 0x00, 0x03, 0x0B, 0x03, 0x16, 0x03, 0x21, 0x03, 0x2D, 0x03, 0x38, 0x03, 0x43, 0x03, 0x4F, 0x03, 0x5A, 0x03, 0x66,
	0x03, 0x72, 0x03, 0x7E, 0x03, 0x8A, 0x03, 0x96, 0x03, 0xA2, 0x03, 0xAE, 0x03, 0xBA, 0x03, 0xC7, 0x03, 0xD3, 0x03, 0xE0, 0x03, 0xEC, 0x03, 0xF9, 0x04, 0x06, 0x04, 0x13, 0x04, 0x20, 0x04, 0x2D, 0x04, 0x3B, 0x04, 0x48, 0x04, 0x55, 0x04, 0x63, 0x04, 0x71, 0x04, 0x7E, 0x04, 0x8C, 0x04, 0x9A, 0x04, 0xA8,
	0x04, 0xB6, 0x04, 0xC4, 0x04, 0xD3, 0x04, 0xE1, 0x04, 0xF0, 0x04, 0xFE, 0x05, 0x0D, 0x05, 0x1C, 0x05, 0x2B, 0x05, 0x3A, 0x05, 0x49, 0x05, 0x58, 0x05, 0x67, 0x05, 0x77, 0x05, 0x86, 0x05, 0x96, 0x05, 0xA6, 0x05, 0xB5, 0x05, 0xC5, 0x05, 0xD5, 0x05, 0xE5, 0x05, 0xF6, 0x06, 0x06, 0x06, 0x16, 0x06, 0x27,
	0x06, 0x37, 0x06, 0x48, 0x06, 0x59, 0x06, 0x6A, 0x06, 0x7B, 0x06, 0x8C, 0x06, 0x9D, 0x06, 0xAF, 0x06, 0xC0, 0x06, 0xD1, 0x06, 0xE3, 0x06, 0xF5, 0x07, 0x07, 0x07, 0x19, 0x07, 0x2B, 0x07, 0x3D, 0x07, 0x4F, 0x07, 0x61, 0x07, 0x74, 0x07, 0x86, 0x07, 0x99, 0x07, 0xAC, 0x07, 0xBF, 0x07, 0xD2, 0x07, 0xE5,
	0x07, 0xF8, 0x08, 0x0B, 0x08, 0x1F, 0x08, 0x32, 0x08, 0x46, 0x08, 0x5A, 0x08, 0x6E, 0x08, 0x82, 0x08, 0x96, 0x08, 0xAA, 0x08, 0xBE, 0x08, 0xD2, 0x08, 0xE7, 0x08, 0xFB, 0x09, 0x10, 0x09, 0x25, 0x09, 0x3A, 0x09, 0x4F, 0x09, 0x64, 0x09, 0x79, 0x09, 0x8F, 0x09, 0xA4, 0x09, 0xBA, 0x09, 0xCF, 0x09, 0xE5,
	0x09, 0xFB, 0x0A, 0x11, 0x0A, 0x27, 0x0A, 0x3D, 0x0A, 0x54, 0x0A, 0x6A, 0x0A, 0x81, 0x0A, 0x98, 0x0A, 0xAE, 0x0A, 0xC5, 0x0A, 0xDC, 0x0A, 0xF3, 0x0B, 0x0B, 0x0B, 0x22, 0x0B, 0x39, 0x0B, 0x51, 0x0B, 0x69, 0x0B, 0x80, 0x0B, 0x98, 0x0B, 0xB0, 0x0B, 0xC8, 0x0B, 0xE1, 0x0B, 0xF9, 0x0C, 0x12, 0x0C, 0x2A,
	0x0C, 0x43, 0x0C, 0x5C, 0x0C, 0x75, 0x0C, 0x8E, 0x0C, 0xA7, 0x0C, 0xC0, 0x0C, 0xD9, 0x0C, 0xF3, 0x0D, 0x0D, 0x0D, 0x26, 0x0D, 0x40, 0x0D, 0x5A, 0x0D, 0x74, 0x0D, 0x8E, 0x0D, 0xA9, 0x0D, 0xC3, 0x0D, 0xDE, 0x0D, 0xF8, 0x0E, 0x13, 0x0E, 0x2E, 0x0E, 0x49, 0x0E, 0x64, 0x0E, 0x7F, 0x0E, 0x9B, 0x0E, 0xB6,
	0x0E, 0xD2, 0x0E, 0xEE, 0x0F, 0x09, 0x0F, 0x25, 0x0F, 0x41, 0x0F, 0x5E, 0x0F, 0x7A, 0x0F, 0x96, 0x0F, 0xB3, 0x0F, 0xCF, 0x0F, 0xEC, 0x10, 0x09, 0x10, 0x26, 0x10, 0x43, 0x10, 0x61, 0x10, 0x7E, 0x10, 0x9B, 0x10, 0xB9, 0x10, 0xD7, 0x10, 0xF5, 0x11, 0x13, 0x11, 0x31, 0x11, 0x4F, 0x11, 0x6D, 0x11, 0x8C,
	0x11, 0xAA, 0x11, 0xC9, 0x11, 0xE8, 0x12, 0x07, 0x12, 0x26, 0x12, 0x45, 0x12, 0x64, 0x12, 0x84, 0x12, 0xA3, 0x12, 0xC3, 0x12, 0xE3, 0x13, 0x03, 0x13, 0x23, 0x13, 0x43, 0x13, 0x63, 0x13, 0x83, 0x13, 0xA4, 0x13, 0xC5, 0x13, 0xE5, 0x14, 0x06, 0x14, 0x27, 0x14, 0x49, 0x14, 0x6A, 0x14, 0x8B, 0x14, 0xAD,
	0x14, 0xCE, 0x14, 0xF0, 0x15, 0x12, 0x15, 0x34, 0x15, 0x56, 0x15, 0x78, 0x15, 0x9B, 0x15, 0xBD, 0x15, 0xE0, 0x16, 0x03, 0x16, 0x26, 0x16, 0x49, 0x16, 0x6C, 0x16, 0x8F, 0x16, 0xB2, 0x16, 0xD6, 0x16, 0xFA, 0x17, 0x1D, 0x17, 0x41, 0x17, 0x65, 0x17, 0x89, 0x17, 0xAE, 0x17, 0xD2, 0x17, 0xF7, 0x18, 0x1B,
	0x18, 0x40, 0x18, 0x65, 0x18, 0x8A, 0x18, 0xAF, 0x18, 0xD5, 0x18, 0xFA, 0x19, 0x20, 0x19, 0x45, 0x19, 0x6B, 0x19, 0x91, 0x19, 0xB7, 0x19, 0xDD, 0x1A, 0x04, 0x1A, 0x2A, 0x1A, 0x51, 0x1A, 0x77, 0x1A, 0x9E, 0x1A, 0xC5, 0x1A, 0xEC, 0x1B, 0x14, 0x1B, 0x3B, 0x1B, 0x63, 0x1B, 0x8A, 0x1B, 0xB2, 0x1B, 0xDA,
	0x1C, 0x02, 0x1C, 0x2A, 0x1C, 0x52, 0x1C, 0x7B, 0x1C, 0xA3, 0x1C, 0xCC, 0x1C, 0xF5, 0x1D, 0x1E, 0x1D, 0x47, 0x1D, 0x70, 0x1D, 0x99, 0x1D, 0xC3, 0x1D, 0xEC, 0x1E, 0x16, 0x1E, 0x40, 0x1E, 0x6A, 0x1E, 0x94, 0x1E, 0xBE, 0x1E, 0xE9, 0x1F, 0x13, 0x1F, 0x3E, 0x1F, 0x69, 0x1F, 0x94, 0x1F, 0xBF, 0x1F, 0xEA,
	0x20, 0x15, 0x20, 0x41, 0x20, 0x6C, 0x20, 0x98, 0x20, 0xC4, 0x20, 0xF0, 0x21, 0x1C, 0x21, 0x48, 0x21, 0x75, 0x21, 0xA1, 0x21, 0xCE, 0x21, 0xFB, 0x22, 0x27, 0x22, 0x55, 0x22, 0x82, 0x22, 0xAF, 0x22, 0xDD, 0x23, 0x0A, 0x23, 0x38, 0x23, 0x66, 0x23, 0x94, 0x23, 0xC2, 0x23, 0xF0, 0x24, 0x1F, 0x24, 0x4D,
	0x24, 0x7C, 0x24, 0xAB, 0x24, 0xDA, 0x25, 0x09, 0x25, 0x38, 0x25, 0x68, 0x25, 0x97, 0x25, 0xC7, 0x25, 0xF7, 0x26, 0x27, 0x26, 0x57, 0x26, 0x87, 0x26, 0xB7, 0x26, 0xE8, 0x27, 0x18, 0x27, 0x49, 0x27, 0x7A, 0x27, 0xAB, 0x27, 0xDC, 0x28, 0x0D, 0x28, 0x3F, 0x28, 0x71, 0x28, 0xA2, 0x28, 0xD4, 0x29, 0x06,
	0x29, 0x38, 0x29, 0x6B, 0x29, 0x9D, 0x29, 0xD0, 0x2A, 0x02, 0x2A, 0x35, 0x2A, 0x68, 0x2A, 0x9B, 0x2A, 0xCF, 0x2B, 0x02, 0x2B, 0x36, 0x2B, 0x69, 0x2B, 0x9D, 0x2B, 0xD1, 0x2C, 0x05, 0x2C, 0x39, 0x2C, 0x6E, 0x2C, 0xA2, 0x2C, 0xD7, 0x2D, 0x0C, 0x2D, 0x41, 0x2D, 0x76, 0x2D, 0xAB, 0x2D, 0xE1, 0x2E, 0x16,
	0x2E, 0x4C, 0x2E, 0x82, 0x2E, 0xB7, 0x2E, 0xEE, 0x2F, 0x24, 0x2F, 0x5A, 0x2F, 0x91, 0x2F, 0xC7, 0x2F, 0xFE, 0x30, 0x35, 0x30, 0x6C, 0x30, 0xA4, 0x30, 0xDB, 0x31, 0x12, 0x31, 0x4A, 0x31, 0x82, 0x31, 0xBA, 0x31, 0xF2, 0x32, 0x2A, 0x32, 0x63, 0x32, 0x9B, 0x32, 0xD4, 0x33, 0x0D, 0x33, 0x46, 0x33, 0x7F,
	0x33, 0xB8, 0x33, 0xF1, 0x34, 0x2B, 0x34, 0x65, 0x34, 0x9E, 0x34, 0xD8, 0x35, 0x13, 0x35, 0x4D, 0x35, 0x87, 0x35, 0xC2, 0x35, 0xFD, 0x36, 0x37, 0x36, 0x72, 0x36, 0xAE, 0x36, 0xE9, 0x37, 0x24, 0x37, 0x60, 0x37, 0x9C, 0x37, 0xD7, 0x38, 0x14, 0x38, 0x50, 0x38, 0x8C, 0x38, 0xC8, 0x39, 0x05, 0x39, 0x42,
	0x39, 0x7F, 0x39, 0xBC, 0x39, 0xF9, 0x3A, 0x36, 0x3A, 0x74, 0x3A, 0xB2, 0x3A, 0xEF, 0x3B, 0x2D, 0x3B, 0x6B, 0x3B, 0xAA, 0x3B, 0xE8, 0x3C, 0x27, 0x3C, 0x65, 0x3C, 0xA4, 0x3C, 0xE3, 0x3D, 0x22, 0x3D, 0x61, 0x3D, 0xA1, 0x3D, 0xE0, 0x3E, 0x20, 0x3E, 0x60, 0x3E, 0xA0, 0x3E, 0xE0, 0x3F, 0x21, 0x3F, 0x61,
	0x3F, 0xA2, 0x3F, 0xE2, 0x40, 0x23, 0x40, 0x64, 0x40, 0xA6, 0x40, 0xE7, 0x41, 0x29, 0x41, 0x6A, 0x41, 0xAC, 0x41, 0xEE, 0x42, 0x30, 0x42, 0x72, 0x42, 0xB5, 0x42, 0xF7, 0x43, 0x3A, 0x43, 0x7D, 0x43, 0xC0, 0x44, 0x03, 0x44, 0x47, 0x44, 0x8A, 0x44, 0xCE, 0x45, 0x12, 0x45, 0x55, 0x45, 0x9A, 0x45, 0xDE,
	0x46, 0x22, 0x46, 0x67, 0x46, 0xAB, 0x46, 0xF0, 0x47, 0x35, 0x47, 0x7B, 0x47, 0xC0, 0x48, 0x05, 0x48, 0x4B, 0x48, 0x91, 0x48, 0xD7, 0x49, 0x1D, 0x49, 0x63, 0x49, 0xA9, 0x49, 0xF0, 0x4A, 0x37, 0x4A, 0x7D, 0x4A, 0xC4, 0x4B, 0x0C, 0x4B, 0x53, 0x4B, 0x9A, 0x4B, 0xE2, 0x4C, 0x2A, 0x4C, 0x72, 0x4C, 0xBA,
	0x4D, 0x02, 0x4D, 0x4A, 0x4D, 0x93, 0x4D, 0xDC, 0x4E, 0x25, 0x4E, 0x6E, 0x4E, 0xB7, 0x4F, 0x00, 0x4F, 0x49, 0x4F, 0x93, 0x4F, 0xDD, 0x50, 0x27, 0x50, 0x71, 0x50, 0xBB, 0x51, 0x06, 0x51, 0x50, 0x51, 0x9B, 0x51, 0xE6, 0x52, 0x31, 0x52, 0x7C, 0x52, 0xC7, 0x53, 0x13, 0x53, 0x5F, 0x53, 0xAA, 0x53, 0xF6,
	0x54, 0x42, 0x54, 0x8F, 0x54, 0xDB, 0x55, 0x28, 0x55, 0x75, 0x55, 0xC2, 0x56, 0x0F, 0x56, 0x5C, 0x56, 0xA9, 0x56, 0xF7, 0x57, 0x44, 0x57, 0x92, 0x57, 0xE0, 0x58, 0x2F, 0x58, 0x7D, 0x58, 0xCB, 0x59, 0x1A, 0x59, 0x69, 0x59, 0xB8, 0x5A, 0x07, 0x5A, 0x56, 0x5A, 0xA6, 0x5A, 0xF5, 0x5B, 0x45, 0x5B, 0x95,
	0x5B, 0xE5, 0x5C, 0x35, 0x5C, 0x86, 0x5C, 0xD6, 0x5D, 0x27, 0x5D, 0x78, 0x5D, 0xC9, 0x5E, 0x1A, 0x5E, 0x6C, 0x5E, 0xBD, 0x5F, 0x0F, 0x5F, 0x61, 0x5F, 0xB3, 0x60, 0x05, 0x60, 0x57, 0x60, 0xAA, 0x60, 0xFC, 0x61, 0x4F, 0x61, 0xA2, 0x61, 0xF5, 0x62, 0x49, 0x62, 0x9C, 0x62, 0xF0, 0x63, 0x43, 0x63, 0x97,
	0x63, 0xEB, 0x64, 0x40, 0x64, 0x94, 0x64, 0xE9, 0x65, 0x3D, 0x65, 0x92, 0x65, 0xE7, 0x66, 0x3D, 0x66, 0x92, 0x66, 0xE8, 0x67, 0x3D, 0x67, 0x93, 0x67, 0xE9, 0x68, 0x3F, 0x68, 0x96, 0x68, 0xEC, 0x69, 0x43, 0x69, 0x9A, 0x69, 0xF1, 0x6A, 0x48, 0x6A, 0x9F, 0x6A, 0xF7, 0x6B, 0x4F, 0x6B, 0xA7, 0x6B, 0xFF,
	0x6C, 0x57, 0x6C, 0xAF, 0x6D, 0x08, 0x6D, 0x60, 0x6D, 0xB9, 0x6E, 0x12, 0x6E, 0x6B, 0x6E, 0xC4, 0x6F, 0x1E, 0x6F, 0x78, 0x6F, 0xD1, 0x70, 0x2B, 0x70, 0x86, 0x70, 0xE0, 0x71, 0x3A, 0x71, 0x95, 0x71, 0xF0, 0x72, 0x4B, 0x72, 0xA6, 0x73, 0x01, 0x73, 0x5D, 0x73, 0xB8, 0x74, 0x14, 0x74, 0x70, 0x74, 0xCC,
	0x75, 0x28, 0x75, 0x85, 0x75, 0xE1, 0x76, 0x3E, 0x76, 0x9B, 0x76, 0xF8, 0x77, 0x56, 0x77, 0xB3, 0x78, 0x11, 0x78, 0x6E, 0x78, 0xCC, 0x79, 0x2A, 0x79, 0x89, 0x79, 0xE7, 0x7A, 0x46, 0x7A, 0xA5, 0x7B, 0x04, 0x7B, 0x63, 0x7B, 0xC2, 0x7C, 0x21, 0x7C, 0x81, 0x7C, 0xE1, 0x7D, 0x41, 0x7D, 0xA1, 0x7E, 0x01,
	0x7E, 0x62, 0x7E, 0xC2, 0x7F, 0x23, 0x7F, 0x84, 0x7F, 0xE5, 0x80, 0x47, 0x80, 0xA8, 0x81, 0x0A, 0x81, 0x6B, 0x81, 0xCD, 0x82, 0x30, 0x82, 0x92, 0x82, 0xF4, 0x83, 0x57, 0x83, 0xBA, 0x84, 0x1D, 0x84, 0x80, 0x84, 0xE3, 0x85, 0x47, 0x85, 0xAB, 0x86, 0x0E, 0x86, 0x72, 0x86, 0xD7, 0x87, 0x3B, 0x87, 0x9F,
	0x88, 0x04, 0x88, 0x69, 0x88, 0xCE, 0x89, 0x33, 0x89, 0x99, 0x89, 0xFE, 0x8A, 0x64, 0x8A, 0xCA, 0x8B, 0x30, 0x8B, 0x96, 0x8B, 0xFC, 0x8C, 0x63, 0x8C, 0xCA, 0x8D, 0x31, 0x8D, 0x98, 0x8D, 0xFF, 0x8E, 0x66, 0x8E, 0xCE, 0x8F, 0x36, 0x8F, 0x9E, 0x90, 0x06, 0x90, 0x6E, 0x90, 0xD6, 0x91, 0x3F, 0x91, 0xA8,
	0x92, 0x11, 0x92, 0x7A, 0x92, 0xE3, 0x93, 0x4D, 0x93, 0xB6, 0x94, 0x20, 0x94, 0x8A, 0x94, 0xF4, 0x95, 0x5F, 0x95, 0xC9, 0x96, 0x34, 0x96, 0x9F, 0x97, 0x0A, 0x97, 0x75, 0x97, 0xE0, 0x98, 0x4C, 0x98, 0xB8, 0x99, 0x24, 0x99, 0x90, 0x99, 0xFC, 0x9A, 0x68, 0x9A, 0xD5, 0x9B, 0x42, 0x9B, 0xAF, 0x9C, 0x1C,
	0x9C, 0x89, 0x9C, 0xF7, 0x9D, 0x64, 0x9D, 0xD2, 0x9E, 0x40, 0x9E, 0xAE, 0x9F, 0x1D, 0x9F, 0x8B, 0x9F, 0xFA, 0xA0, 0x69, 0xA0, 0xD8, 0xA1, 0x47, 0xA1, 0xB6, 0xA2, 0x26, 0xA2, 0x96, 0xA3, 0x06, 0xA3, 0x76, 0xA3, 0xE6, 0xA4, 0x56, 0xA4, 0xC7, 0xA5, 0x38, 0xA5, 0xA9, 0xA6, 0x1A, 0xA6, 0x8B, 0xA6, 0xFD,
	0xA7, 0x6E, 0xA7, 0xE0, 0xA8, 0x52, 0xA8, 0xC4, 0xA9, 0x37, 0xA9, 0xA9, 0xAA, 0x1C, 0xAA, 0x8F, 0xAB, 0x02, 0xAB, 0x75, 0xAB, 0xE9, 0xAC, 0x5C, 0xAC, 0xD0, 0xAD, 0x44, 0xAD, 0xB8, 0xAE, 0x2D, 0xAE, 0xA1, 0xAF, 0x16, 0xAF, 0x8B, 0xB0, 0x00, 0xB0, 0x75, 0xB0, 0xEA, 0xB1, 0x60, 0xB1, 0xD6, 0xB2, 0x4B,
	0xB2, 0xC2, 0xB3, 0x38, 0xB3, 0xAE, 0xB4, 0x25, 0xB4, 0x9C, 0xB5, 0x13, 0xB5, 0x8A, 0xB6, 0x01, 0xB6, 0x79, 0xB6, 0xF0, 0xB7, 0x68, 0xB7, 0xE0, 0xB8, 0x59, 0xB8, 0xD1, 0xB9, 0x4A, 0xB9, 0xC2, 0xBA, 0x3B, 0xBA, 0xB5, 0xBB, 0x2E, 0xBB, 0xA7, 0xBC, 0x21, 0xBC, 0x9B, 0xBD, 0x15, 0xBD, 0x8F, 0xBE, 0x0A,
	0xBE, 0x84, 0xBE, 0xFF, 0xBF, 0x7A, 0xBF, 0xF5, 0xC0, 0x70, 0xC0, 0xEC, 0xC1, 0x67, 0xC1, 0xE3, 0xC2, 0x5F, 0xC2, 0xDB, 0xC3, 0x58, 0xC3, 0xD4, 0xC4, 0x51, 0xC4, 0xCE, 0xC5, 0x4B, 0xC5, 0xC8, 0xC6, 0x46, 0xC6, 0xC3, 0xC7, 0x41, 0xC7, 0xBF, 0xC8, 0x3D, 0xC8, 0xBC, 0xC9, 0x3A, 0xC9, 0xB9, 0xCA, 0x38,
	0xCA, 0xB7, 0xCB, 0x36, 0xCB, 0xB6, 0xCC, 0x35, 0xCC, 0xB5, 0xCD, 0x35, 0xCD, 0xB5, 0xCE, 0x36, 0xCE, 0xB6, 0xCF, 0x37, 0xCF, 0xB8, 0xD0, 0x39, 0xD0, 0xBA, 0xD1, 0x3C, 0xD1, 0xBE, 0xD2, 0x3F, 0xD2, 0xC1, 0xD3, 0x44, 0xD3, 0xC6, 0xD4, 0x49, 0xD4, 0xCB, 0xD5, 0x4E, 0xD5, 0xD1, 0xD6, 0x55, 0xD6, 0xD8,
	0xD7, 0x5C, 0xD7, 0xE0, 0xD8, 0x64, 0xD8, 0xE8, 0xD9, 0x6C, 0xD9, 0xF1, 0xDA, 0x76, 0xDA, 0xFB, 0xDB, 0x80, 0xDC, 0x05, 0xDC, 0x8A, 0xDD, 0x10, 0xDD, 0x96, 0xDE, 0x1C, 0xDE, 0xA2, 0xDF, 0x29, 0xDF, 0xAF, 0xE0, 0x36, 0xE0, 0xBD, 0xE1, 0x44, 0xE1, 0xCC, 0xE2, 0x53, 0xE2, 0xDB, 0xE3, 0x63, 0xE3, 0xEB,
	0xE4, 0x73, 0xE4, 0xFC, 0xE5, 0x84, 0xE6, 0x0D, 0xE6, 0x96, 0xE7, 0x1F, 0xE7, 0xA9, 0xE8, 0x32, 0xE8, 0xBC, 0xE9, 0x46, 0xE9, 0xD0, 0xEA, 0x5B, 0xEA, 0xE5, 0xEB, 0x70, 0xEB, 0xFB, 0xEC, 0x86, 0xED, 0x11, 0xED, 0x9C, 0xEE, 0x28, 0xEE, 0xB4, 0xEF, 0x40, 0xEF, 0xCC, 0xF0, 0x58, 0xF0, 0xE5, 0xF1, 0x72,
	0xF1, 0xFF, 0xF2, 0x8C, 0xF3, 0x19, 0xF3, 0xA7, 0xF4, 0x34, 0xF4, 0xC2, 0xF5, 0x50, 0xF5, 0xDE, 0xF6, 0x6D, 0xF6, 0xFB, 0xF7, 0x8A, 0xF8, 0x19, 0xF8, 0xA8, 0xF9, 0x38, 0xF9, 0xC7, 0xFA, 0x57, 0xFA, 0xE7, 0xFB, 0x77, 0xFC, 0x07, 0xFC, 0x98, 0xFD, 0x29, 0xFD, 0xBA, 0xFE, 0x4B, 0xFE, 0xDC, 0xFF, 0x6D,
	0xFF, 0xFF, 0xFF, 0xEE, 0x00, 0x21, 0x41, 0x64, 0x6F, 0x62, 0x65, 0x00, 0x64, 0x40, 0x00, 0x00, 0x00, 0x01, 0x03, 0x00, 0x10, 0x03, 0x02, 0x03, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xDB, 0x00, 0x84, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x03, 0x03, 0x03, 0x03,
	0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x02, 0x01, 0x02, 0x02, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
	0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0xFF, 0xC2, 0x00, 0x11, 0x08, 0x00, 0x27, 0x00, 0xB8, 0x03, 0x01, 0x11, 0x00, 0x02, 0x11, 0x01, 0x03, 0x11, 0x01, 0xFF, 0xC4, 0x00, 0xC7, 0x00, 0x00, 0x01, 0x04, 0x03, 0x01,
	0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x08, 0x09, 0x0A, 0x02, 0x03, 0x07, 0x04, 0x06, 0x01, 0x01, 0x00, 0x02, 0x03, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x06, 0x01, 0x02, 0x08, 0x04, 0x07, 0x10, 0x00, 0x00, 0x04,
	0x05, 0x04, 0x02, 0x02, 0x02, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x07, 0x08, 0x09, 0x01, 0x02, 0x03, 0x04, 0x05, 0x00, 0x11, 0x12, 0x13, 0x10, 0x40, 0x50, 0x0A, 0x21, 0x23, 0x22, 0x14, 0x15, 0x11, 0x00, 0x00, 0x06, 0x01, 0x03, 0x02, 0x03, 0x05, 0x06, 0x04, 0x04, 0x07, 0x01, 0x00,
	0x00, 0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x11, 0x12, 0x08, 0x00, 0x13, 0x31, 0x41, 0x09, 0x21, 0x51, 0x22, 0x32, 0x14, 0x10, 0x61, 0x81, 0x42, 0x15, 0x16, 0x71, 0xA1, 0x52, 0x23, 0x91, 0x82, 0x63, 0x18, 0x40, 0xF0, 0x62, 0xA2, 0x33, 0x24, 0x25, 0x0A, 0x12, 0x00, 0x01, 0x02, 0x05, 0x02,
	0x03, 0x06, 0x04, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x11, 0x02, 0x21, 0x31, 0x12, 0x03, 0x04, 0x00, 0x05, 0x40, 0x51, 0x61, 0x41, 0x91, 0x22, 0x32, 0x13, 0x06, 0x10, 0x50, 0x71, 0xC1, 0xF0, 0x81, 0xA1, 0xA2, 0xC2, 0x33, 0x14, 0xFF, 0xDA, 0x00, 0x0C, 0x03, 0x01, 0x01, 0x02, 0x11,
	0x03, 0x11, 0x00, 0x00, 0x00, 0xBF, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xA0, 0x84, 0x52, 0x67, 0x4A, 0xCF, 0x96, 0x7F, 0x2B, 0x9E, 0x77, 0xF1, 0xD9, 0x8C, 0xCC, 0xE5, 0x64, 0xE4, 0x11, 0x22, 0x37, 0x22, 0x7A, 0x08, 0xBA, 0x38, 0xC1, 0x30, 0xF3, 0xD0, 0xCD,
	0xB6, 0xDB, 0x07, 0x22, 0x9F, 0x32, 0xBA, 0x7B, 0xF6, 0xCF, 0x8C, 0xF7, 0x00, 0xDF, 0xCA, 0x6D, 0x96, 0xF1, 0x2B, 0xD2, 0x3E, 0x82, 0x05, 0x4B, 0xDB, 0x14, 0xAE, 0x2D, 0x5C, 0x41, 0xB9, 0x67, 0x82, 0x16, 0xC6, 0x4E, 0x7D, 0x88, 0xE8, 0xC6, 0x2E, 0x72, 0x7E, 0xE5, 0xE5, 0x26, 0xE9, 0x67, 0xAF, 0x3B,
	0x9E, 0x46, 0xEA, 0x19, 0xE1, 0xA1, 0xD8, 0x9E, 0xEC, 0x47, 0xAF, 0x60, 0x15, 0xAC, 0x24, 0x68, 0xAF, 0xF0, 0xF0, 0xCE, 0x1A, 0x79, 0x8B, 0x4A, 0x95, 0x6C, 0x2D, 0x60, 0x57, 0x28, 0x70, 0x87, 0x7D, 0x18, 0x40, 0xF0, 0x8E, 0x62, 0x47, 0xA9, 0x6F, 0x6D, 0x11, 0x0F, 0x68, 0x8B, 0xAD, 0x5D, 0xE6, 0xB9,
	0x71, 0x3F, 0x99, 0xDB, 0x1E, 0x14, 0x6F, 0xAF, 0x20, 0x30, 0x31, 0x14, 0x41, 0x4C, 0x84, 0x10, 0xD8, 0x60, 0x28, 0x08, 0x62, 0x21, 0x91, 0xB0, 0xC3, 0x03, 0x6C, 0xAE, 0x1A, 0x18, 0xFF, 0xDA, 0x00, 0x08, 0x01, 0x02, 0x00, 0x01, 0x05, 0x00, 0xF8, 0x90, 0xF8, 0x38, 0x5A, 0x2F, 0xBB, 0xCC, 0x13, 0x06,
	0x66, 0x22, 0x84, 0x37, 0x8C, 0x3D, 0x44, 0xD2, 0x26, 0x0D, 0x87, 0x00, 0x43, 0xF5, 0x07, 0x89, 0x0B, 0x63, 0x64, 0x00, 0xDF, 0xE6, 0xAA, 0xE7, 0xF1, 0x53, 0x61, 0x32, 0xDE, 0x9F, 0x5C, 0xB0, 0xD0, 0x4C, 0x47, 0x28, 0x6A, 0xEE, 0xA9, 0x8F, 0x88, 0x84, 0xB9, 0x8C, 0xAC, 0xB9, 0xBC, 0x9F, 0xA9, 0x37,
	0x1D, 0xA1, 0xBE, 0xFE, 0x3F, 0xFF, 0xDA, 0x00, 0x08, 0x01, 0x03, 0x00, 0x01, 0x05, 0x00, 0xF8, 0x9C, 0xB8, 0x97, 0x09, 0x80, 0x92, 0xCC, 0xC7, 0x07, 0x64, 0x2E, 0x21, 0x1D, 0xE1, 0xEA, 0x1E, 0x58, 0x1C, 0xD6, 0x78, 0x5A, 0x01, 0x24, 0x2E, 0xB3, 0x75, 0x25, 0xCD, 0xC9, 0x65, 0x4E, 0xC6, 0xE7, 0xFB,
	0x96, 0xBE, 0x9E, 0xD0, 0x96, 0x7C, 0xAE, 0x3E, 0x6C, 0x84, 0x94, 0x83, 0x75, 0xA9, 0xC6, 0xC6, 0xDE, 0x36, 0x96, 0xBE, 0xAF, 0xE7, 0x78, 0xEF, 0xE3, 0xFF, 0xDA, 0x00, 0x08, 0x01, 0x01, 0x00, 0x01, 0x05, 0x00, 0xF6, 0x66, 0x8E, 0xD1, 0x17, 0x3C, 0x88, 0x04, 0x32, 0xF4, 0x99, 0xFA, 0x82, 0x1F, 0xF1,
	0x4E, 0x57, 0xD4, 0x50, 0x88, 0xC5, 0xCF, 0xA5, 0x8E, 0xF2, 0xBA, 0xA3, 0xE4, 0x0A, 0xD1, 0x12, 0xE0, 0x5F, 0x0B, 0x11, 0xCE, 0x90, 0xEA, 0x5A, 0x6C, 0xF5, 0x68, 0x2B, 0x5C, 0x68, 0xD8, 0xB4, 0x5D, 0xCE, 0x00, 0x79, 0xAD, 0xC3, 0x91, 0xCC, 0x5C, 0x6C, 0xA1, 0x71, 0x1C, 0xA4, 0xE7, 0x5C, 0x85, 0x1A,
	0x47, 0x5A, 0x8E, 0x58, 0xAB, 0x4C, 0x80, 0x83, 0xEE, 0x8C, 0x0A, 0x37, 0x4F, 0x3B, 0x6E, 0x4F, 0xEA, 0x40, 0x16, 0xF1, 0x5B, 0x2B, 0xFD, 0xC0, 0xD2, 0xAA, 0x07, 0x73, 0xE5, 0xF2, 0xB6, 0xD5, 0x79, 0xEE, 0xAB, 0xD3, 0x8A, 0x64, 0xB2, 0x00, 0xBB, 0x2B, 0x77, 0x19, 0x59, 0xEB, 0x78, 0x52, 0xB9, 0xA3,
	0x24, 0xBC, 0x25, 0xB9, 0x85, 0x4D, 0xBC, 0x2A, 0x25, 0x04, 0x04, 0x4A, 0x09, 0xED, 0x5B, 0xA7, 0x29, 0x2D, 0xD9, 0xC1, 0x0F, 0xAA, 0xE0, 0x2A, 0xE1, 0x49, 0xAE, 0x54, 0x87, 0xF1, 0x6E, 0x2E, 0xE0, 0xCD, 0x3E, 0xEA, 0x21, 0xA3, 0xAD, 0xA9, 0x15, 0xD9, 0x42, 0x3D, 0xC1, 0xE7, 0xB2, 0x38, 0xFB, 0x5C,
	0xB5, 0xAD, 0xDD, 0xF2, 0xAB, 0x62, 0x85, 0xB4, 0x88, 0x12, 0x40, 0x21, 0x15, 0x26, 0xF5, 0x8D, 0x5A, 0x8C, 0xFF, 0x00, 0x67, 0xC8, 0xD3, 0x96, 0x31, 0x69, 0x89, 0x63, 0x31, 0xF2, 0x65, 0xA0, 0x82, 0x51, 0xCC, 0x56, 0x5B, 0x3A, 0x38, 0x49, 0xE2, 0x13, 0x35, 0xFE, 0xBD, 0x96, 0x50, 0xC7, 0xB5, 0x53,
	0x15, 0x4B, 0x4E, 0xAB, 0xA2, 0xBE, 0xB1, 0x1E, 0x72, 0x9D, 0x2B, 0xB9, 0x21, 0xB3, 0x68, 0xC8, 0xE1, 0xBD, 0x31, 0xBE, 0xCD, 0xE4, 0x82, 0x7A, 0xCC, 0xB7, 0x02, 0xA9, 0x13, 0xAD, 0x94, 0x61, 0x3D, 0x3E, 0x5E, 0x5E, 0x44, 0xE5, 0x90, 0xF4, 0x50, 0xE2, 0x56, 0xB0, 0x6A, 0x10, 0xF8, 0x61, 0x83, 0x8E,
	0x81, 0xAA, 0x0B, 0x33, 0x4A, 0xB5, 0x78, 0x18, 0xBE, 0x7B, 0x43, 0xD1, 0xA5, 0x0F, 0x8B, 0xE7, 0x90, 0x7D, 0x53, 0x6B, 0x2E, 0x74, 0x2A, 0xA2, 0x6C, 0xE2, 0x07, 0x1F, 0x25, 0xEB, 0xAB, 0x1F, 0xD7, 0x86, 0x5B, 0xA1, 0x15, 0xA6, 0x30, 0x64, 0xDC, 0x00, 0x3D, 0x31, 0x02, 0xAC, 0x4A, 0x95, 0xD3, 0x8B,
	0xFB, 0x03, 0xA6, 0xA1, 0x70, 0x61, 0xB0, 0x89, 0x13, 0x5D, 0x2B, 0x26, 0x24, 0x1E, 0xAB, 0x71, 0x11, 0x76, 0x07, 0x8D, 0x6C, 0x7C, 0x9A, 0xF1, 0x2A, 0xD9, 0x20, 0x64, 0x32, 0x4D, 0x2C, 0xBA, 0xCB, 0xE6, 0xB6, 0x5C, 0xA4, 0x71, 0x39, 0x28, 0xD0, 0x9E, 0x2F, 0x0C, 0xD7, 0x97, 0xAE, 0x84, 0x4C, 0xE1,
	0xFE, 0xAC, 0x8B, 0x92, 0xAE, 0x75, 0x01, 0xA5, 0x2A, 0x28, 0x85, 0x21, 0xCD, 0x34, 0x25, 0xF3, 0xFA, 0xFB, 0x25, 0xE9, 0xDF, 0xF5, 0xF2, 0x84, 0x28, 0xEF, 0x37, 0x5E, 0xA3, 0xC7, 0x5F, 0xC3, 0x53, 0x75, 0xF2, 0xD4, 0x7A, 0xF9, 0xC7, 0x8F, 0x28, 0xF1, 0xD4, 0xDC, 0x77, 0x87, 0x56, 0xA6, 0xE9, 0xD4,
	0x3A, 0x76, 0xD4, 0x78, 0x6A, 0x6E, 0xBE, 0x32, 0xF1, 0xE3, 0x5E, 0x31, 0x86, 0xBF, 0xFF, 0xDA, 0x00, 0x08, 0x01, 0x02, 0x02, 0x06, 0x3F, 0x00, 0xF9, 0x4D, 0x1E, 0xD8, 0xDA, 0xAE, 0x64, 0xB6, 0xCF, 0xF6, 0x00, 0xD4, 0x6C, 0x62, 0x09, 0x79, 0x41, 0x05, 0xEC, 0x3A, 0xB9, 0x97, 0x93, 0xED, 0x5B, 0xED,
	0xC7, 0xB6, 0x01, 0x7B, 0xDA, 0x45, 0xC6, 0x80, 0x81, 0xCA, 0x81, 0xC4, 0x18, 0x18, 0xF2, 0x92, 0x43, 0x4E, 0x05, 0x54, 0x12, 0x0A, 0x8A, 0x4A, 0x82, 0x86, 0x08, 0x12, 0x23, 0x97, 0x5E, 0x17, 0x7C, 0xC8, 0xF7, 0x16, 0xF9, 0x6F, 0x06, 0xC3, 0xB7, 0x17, 0xB6, 0xA7, 0xDC, 0x40, 0xE1, 0xE8, 0x31, 0x1A,
	0x6D, 0xAC, 0x45, 0x52, 0x51, 0x13, 0xAD, 0xA6, 0xCF, 0xB0, 0x77, 0x0C, 0x5D, 0xDE, 0xEE, 0x5D, 0x97, 0x33, 0x25, 0x95, 0x3D, 0xAD, 0x62, 0xA8, 0x0E, 0x36, 0x5B, 0xE0, 0x6B, 0x91, 0x24, 0x15, 0xC7, 0xC4, 0x62, 0x4E, 0xAF, 0x6E, 0x97, 0x77, 0x0B, 0x2C, 0x7E, 0x4D, 0xD7, 0xDC, 0x2D, 0x52, 0x52, 0xA7,
	0x12, 0x40, 0x2E, 0x8F, 0x7C, 0xBA, 0xEB, 0x2F, 0x6C, 0x37, 0x03, 0xDD, 0x6A, 0x98, 0x89, 0x1A, 0x98, 0xD7, 0xFF, 0x00, 0x24, 0xE1, 0x1E, 0x03, 0x45, 0x25, 0xD5, 0x18, 0x4D, 0xC8, 0x1B, 0x51, 0xE6, 0x69, 0x01, 0xAB, 0x34, 0x00, 0x48, 0x0D, 0x64, 0xDE, 0x38, 0xAD, 0x73, 0x1E, 0x00, 0x90, 0xEC, 0x08,
	0x11, 0x7B, 0xA6, 0x12, 0x1C, 0xB5, 0xEB, 0xDD, 0xC1, 0x7B, 0xF3, 0x5D, 0xE6, 0x08, 0xB2, 0x80, 0xFD, 0xA9, 0xAC, 0xAD, 0xCD, 0x98, 0xFE, 0x93, 0x2E, 0x96, 0xA3, 0x79, 0x52, 0xD0, 0xCE, 0x42, 0x74, 0xAF, 0xE7, 0xC2, 0xF8, 0xA5, 0xA8, 0x79, 0xBE, 0x3F, 0xFF, 0xDA, 0x00, 0x08, 0x01, 0x03, 0x02, 0x06,
	0x3F, 0x00, 0xF9, 0x4B, 0x5D, 0xBC, 0xEE, 0x56, 0x6C, 0x34, 0xCA, 0xA2, 0x01, 0xD3, 0x71, 0xAD, 0x6F, 0x98, 0xE2, 0xF3, 0x8F, 0x84, 0x28, 0x0B, 0xA5, 0xA8, 0x15, 0x8A, 0x89, 0x10, 0x65, 0x2E, 0x9C, 0x2E, 0xCF, 0x87, 0xB5, 0x6C, 0xAF, 0xCB, 0x6F, 0xF9, 0x1C, 0xE7, 0x36, 0x9A, 0x9A, 0xA0, 0xF9, 0x90,
	0x82, 0x14, 0x04, 0x8F, 0x4D, 0x66, 0x5F, 0xF7, 0x1E, 0x2E, 0x46, 0xDF, 0xFE, 0x77, 0xB5, 0xD6, 0x5C, 0xDB, 0x76, 0xDA, 0xE7, 0x20, 0x04, 0x80, 0xF2, 0x03, 0xC8, 0xA9, 0x60, 0x4A, 0x76, 0x49, 0x35, 0x63, 0x0E, 0xCD, 0x97, 0x1B, 0x76, 0x98, 0xD6, 0xAB, 0x80, 0x04, 0xD2, 0xD0, 0x14, 0x81, 0x08, 0x90,
	0xB0, 0x9C, 0xF5, 0x6F, 0x26, 0x94, 0xA9, 0x61, 0xF4, 0x24, 0x7D, 0xB8, 0x41, 0x74, 0x42, 0xE0, 0x08, 0xBD, 0xA9, 0x34, 0x59, 0xA2, 0xC5, 0x34, 0x8E, 0x72, 0xFD, 0x63, 0xAF, 0x4D, 0xB0, 0x60, 0xEE, 0xFC, 0x29, 0xD5, 0xAC, 0x73, 0x36, 0xAF, 0xEA, 0x49, 0xFB, 0xF0, 0xDD, 0x75, 0x19, 0xFC, 0x3F, 0xFF,
	0xDA, 0x00, 0x08, 0x01, 0x01, 0x01, 0x06, 0x3F, 0x00, 0xFF, 0x00, 0x89, 0xF1, 0x37, 0x80, 0x8E, 0x81, 0xA8, 0x1B, 0x40, 0x0D, 0x04, 0xC5, 0x0D, 0x04, 0x14, 0xD0, 0x4C, 0x00, 0x05, 0xD3, 0x4D, 0x47, 0xAA, 0x17, 0xA5, 0x47, 0x62, 0x01, 0x48, 0x9B, 0x2E, 0x18, 0x93, 0x91, 0x9F, 0xC8, 0x66, 0x59, 0x77,
	0x12, 0x51, 0x1C, 0x8D, 0x77, 0x1E, 0xDA, 0xFF, 0x00, 0x55, 0xC4, 0x00, 0xAB, 0x57, 0xA4, 0x86, 0x62, 0x57, 0x18, 0x7D, 0xAA, 0xB2, 0x6B, 0x95, 0xC2, 0x62, 0xF0, 0x5E, 0x48, 0xB2, 0x48, 0x81, 0xA2, 0x85, 0x03, 0x4C, 0x0D, 0x6B, 0xF4, 0x90, 0xB1, 0x7E, 0x9C, 0xFB, 0xF4, 0x01, 0x9C, 0x51, 0xE0, 0xC1,
	0x7E, 0xB3, 0xF4, 0x6B, 0x0C, 0x61, 0x65, 0xD4, 0x60, 0x9A, 0x6F, 0xC9, 0x16, 0x77, 0xA2, 0x40, 0x54, 0xC8, 0x91, 0x65, 0x3B, 0x5A, 0x89, 0x43, 0x76, 0x81, 0xD7, 0x1D, 0x3D, 0x3D, 0x79, 0xAB, 0x82, 0xB0, 0x04, 0x15, 0x53, 0x37, 0xB5, 0xA1, 0xBE, 0x93, 0xE4, 0x2E, 0x17, 0xCA, 0x79, 0x1E, 0xC1, 0x03,
	0x54, 0x65, 0x97, 0x26, 0x2E, 0x94, 0x7C, 0x6E, 0xBC, 0xAC, 0x0D, 0xE3, 0x1F, 0x56, 0x02, 0x0D, 0xC8, 0x64, 0xAA, 0x97, 0x62, 0x44, 0xAE, 0x1D, 0x28, 0x81, 0x22, 0xD5, 0x15, 0xC8, 0x71, 0x29, 0x74, 0x28, 0x68, 0x22, 0x3F, 0xD3, 0xEC, 0x31, 0x47, 0x6F, 0x90, 0x88, 0x18, 0x75, 0xF6, 0x7B, 0xC7, 0xC7,
	0xAE, 0x25, 0x70, 0x23, 0x8F, 0x78, 0x5F, 0x1F, 0xE7, 0x7C, 0xC7, 0xC8, 0xF9, 0x7A, 0x4C, 0x05, 0x9D, 0x7B, 0xCE, 0x41, 0xB6, 0x63, 0xFA, 0xD6, 0x35, 0x94, 0xCC, 0xD7, 0xB6, 0x38, 0xEB, 0x0D, 0x34, 0x99, 0x9B, 0xAB, 0x52, 0x6E, 0x6A, 0x23, 0xFB, 0x8A, 0x49, 0xBC, 0xB3, 0xD7, 0x86, 0x4D, 0x25, 0x9D,
	0x34, 0x60, 0xD1, 0x25, 0x41, 0xB8, 0x82, 0x84, 0x31, 0xA5, 0x79, 0x43, 0x15, 0xC6, 0x8E, 0x30, 0x72, 0x46, 0x33, 0x17, 0xD4, 0x15, 0xB2, 0xE7, 0x5A, 0x16, 0x3B, 0xCA, 0x79, 0x5A, 0xB3, 0x68, 0xAC, 0x47, 0x37, 0x94, 0x58, 0xD2, 0xB7, 0x4A, 0x21, 0xE6, 0xB1, 0xD4, 0x9A, 0x57, 0x7A, 0x45, 0x5E, 0x00,
	0xA5, 0x5E, 0x48, 0xCB, 0xA5, 0x18, 0xF4, 0xA9, 0x0A, 0x8E, 0x53, 0x6E, 0x09, 0x36, 0x39, 0x4D, 0x89, 0x39, 0x59, 0x65, 0x71, 0x86, 0xCA, 0x6C, 0xC7, 0x10, 0x16, 0x58, 0xB8, 0x7C, 0x23, 0x62, 0xB6, 0x5C, 0x2B, 0xF4, 0xF6, 0xEA, 0x24, 0x93, 0x39, 0x1A, 0x45, 0x9E, 0x5A, 0xD5, 0x0B, 0x05, 0x24, 0xE7,
	0x22, 0x52, 0x2D, 0x0D, 0x9E, 0xC5, 0xCD, 0xB7, 0x49, 0xAB, 0x76, 0xC8, 0x3A, 0x6C, 0x72, 0xA6, 0x2A, 0x14, 0xA0, 0xA9, 0xF9, 0x23, 0xC5, 0x6C, 0x31, 0x86, 0x78, 0x95, 0x69, 0xC5, 0xBC, 0x5C, 0xB4, 0xD6, 0xEB, 0xD9, 0x53, 0x93, 0xCE, 0xB2, 0x76, 0x6A, 0x6D, 0x5A, 0x85, 0x9D, 0xB3, 0xB3, 0x6F, 0x63,
	0x47, 0x0A, 0xC6, 0x54, 0x10, 0xC7, 0x2F, 0x0B, 0x6E, 0xCD, 0xF5, 0x3A, 0x8B, 0xE4, 0x5C, 0x4E, 0x11, 0x84, 0xB8, 0xC4, 0xB3, 0x55, 0xCA, 0x49, 0x2E, 0xE5, 0x07, 0x25, 0x3B, 0x74, 0xF0, 0x47, 0xA7, 0x32, 0x9C, 0x74, 0xE1, 0xB5, 0x9A, 0xF3, 0xC9, 0x3A, 0x65, 0xC3, 0x23, 0xE3, 0x9C, 0xBA, 0xDF, 0x38,
	0x66, 0x88, 0x7A, 0x44, 0x25, 0x3E, 0x94, 0x95, 0x9D, 0xCC, 0xC0, 0x5E, 0xEA, 0xAA, 0x62, 0x59, 0x39, 0xF6, 0x53, 0xE0, 0xD2, 0xAA, 0xB1, 0x12, 0x6E, 0xC9, 0xE3, 0xA4, 0x0C, 0xB2, 0xC9, 0x98, 0x55, 0x2E, 0xED, 0x00, 0x4D, 0x08, 0x4C, 0x66, 0xAE, 0x77, 0xFD, 0xAC, 0xD7, 0x62, 0x72, 0xAA, 0x5B, 0x09,
	0x89, 0xFF, 0x00, 0x7C, 0x99, 0xBA, 0x1F, 0x5C, 0xDD, 0x47, 0x0C, 0x5B, 0xB9, 0xB7, 0xA5, 0x56, 0x23, 0xD1, 0x50, 0x12, 0x5F, 0xB0, 0x67, 0x1D, 0xAD, 0x0C, 0x64, 0xCB, 0xA8, 0x90, 0x39, 0x61, 0x8F, 0x8F, 0x84, 0xB8, 0x59, 0x8B, 0xBF, 0xDA, 0x1E, 0x6A, 0x9B, 0xE3, 0xF5, 0xBE, 0x69, 0xC6, 0x5D, 0xCD,
	0xD7, 0x80, 0xBA, 0xE4, 0x68, 0xFA, 0x85, 0x7A, 0xE6, 0xD9, 0xED, 0x5A, 0x35, 0x9E, 0x33, 0xAC, 0x92, 0x36, 0xA4, 0xB4, 0x1D, 0xB1, 0x98, 0xAA, 0xA3, 0xC5, 0x95, 0x76, 0x82, 0xE2, 0x60, 0x2B, 0x65, 0x40, 0xA0, 0x73, 0x4A, 0x7A, 0x63, 0xFA, 0x81, 0xE2, 0xCC, 0x3B, 0x84, 0x64, 0x65, 0xDA, 0xD3, 0x23,
	0x71, 0xB6, 0x76, 0xC4, 0x99, 0x2A, 0xE5, 0x76, 0xC5, 0xF3, 0xF7, 0xCC, 0x83, 0x05, 0x1B, 0x68, 0xA5, 0x53, 0x2C, 0x4F, 0x6E, 0xD4, 0x9A, 0x3C, 0x85, 0x69, 0xE5, 0xB2, 0x3A, 0x48, 0xEC, 0x5A, 0x98, 0xE9, 0x10, 0xC4, 0x99, 0x22, 0x28, 0x68, 0x74, 0x56, 0x2A, 0xDD, 0x2C, 0xF3, 0x8D, 0xAC, 0xF1, 0x2C,
	0xD6, 0x49, 0x49, 0xF3, 0x43, 0xB7, 0x8F, 0xCD, 0x12, 0xF7, 0x28, 0x1A, 0x3C, 0xA4, 0x40, 0x10, 0xEA, 0x48, 0x22, 0x13, 0x54, 0x58, 0x49, 0xD9, 0x98, 0xF9, 0x05, 0x48, 0x05, 0xFA, 0x65, 0x8A, 0xC5, 0xCA, 0x5E, 0xDF, 0x88, 0x74, 0xE9, 0xE7, 0x28, 0x63, 0x31, 0x0F, 0x10, 0xB1, 0x33, 0x0B, 0x41, 0xF2,
	0x65, 0x63, 0x0F, 0xD4, 0x64, 0x32, 0x6E, 0x66, 0xBA, 0xBC, 0x91, 0xBD, 0xE2, 0xAC, 0x9B, 0x63, 0xC5, 0x93, 0xAE, 0x72, 0x54, 0x93, 0x4A, 0x05, 0x55, 0x3A, 0xAD, 0x41, 0xF4, 0xF5, 0x3D, 0xF2, 0xCD, 0x01, 0x82, 0x32, 0xD2, 0x07, 0x68, 0x74, 0x54, 0x3A, 0x25, 0x31, 0x8C, 0x40, 0xE5, 0x7F, 0x1A, 0x1E,
	0x71, 0xD7, 0x8A, 0x78, 0xB1, 0x9F, 0x06, 0x33, 0x04, 0x66, 0x2B, 0xE4, 0x15, 0xC4, 0x33, 0x56, 0x53, 0xB8, 0x3D, 0xB3, 0xAE, 0xBC, 0xF5, 0xAE, 0x25, 0x65, 0xF0, 0xFD, 0x7D, 0x2C, 0x5D, 0x04, 0x47, 0x08, 0xBE, 0x6D, 0x4A, 0x78, 0xAA, 0x4B, 0xCD, 0x3C, 0x67, 0xF4, 0xE6, 0x55, 0x32, 0x28, 0x43, 0x1C,
	0x0C, 0x00, 0xDD, 0xFE, 0x7B, 0xCD, 0xB4, 0x3C, 0x54, 0x59, 0x14, 0xD5, 0x52, 0x31, 0xA5, 0xB6, 0x79, 0xB3, 0x19, 0x69, 0x26, 0xE0, 0xA0, 0xB6, 0x2A, 0xF1, 0x70, 0x7D, 0xC5, 0x25, 0x24, 0x11, 0x15, 0x90, 0x31, 0x41, 0x54, 0xD1, 0x31, 0x45, 0x50, 0x10, 0x01, 0xF6, 0xE9, 0xD1, 0x2B, 0x55, 0xCE, 0x56,
	0xE3, 0xB4, 0x66, 0x5D, 0xA8, 0x56, 0xCC, 0x99, 0x59, 0x9E, 0xCA, 0x53, 0xCE, 0xF0, 0xEB, 0x01, 0xC4, 0x08, 0xC5, 0x6B, 0x3C, 0x74, 0x33, 0x47, 0x23, 0xFD, 0xB0, 0x12, 0x9C, 0x0E, 0x6F, 0x9B, 0xD8, 0x3A, 0x0F, 0x49, 0x38, 0x45, 0xD1, 0xD6, 0x45, 0x62, 0x15, 0x44, 0x56, 0x4D, 0x61, 0x32, 0x4A, 0xA4,
	0x70, 0xD5, 0x35, 0x12, 0x50, 0xA7, 0x12, 0xA8, 0x99, 0xCA, 0x20, 0x25, 0x30, 0x08, 0x81, 0x80, 0x75, 0x01, 0x10, 0x1D, 0x7A, 0x02, 0xEA, 0x63, 0x69, 0xAF, 0xB4, 0xC2, 0x26, 0x30, 0xEA, 0x22, 0x3E, 0xD1, 0x1D, 0x44, 0x7C, 0x7A, 0xF8, 0x4E, 0x72, 0xE9, 0xAF, 0x81, 0x84, 0x3E, 0xF0, 0xF0, 0x10, 0xFB,
	0x73, 0x47, 0x24, 0xF2, 0x73, 0x93, 0x35, 0xA2, 0xE1, 0x4C, 0x73, 0x68, 0xC8, 0xD6, 0x10, 0x41, 0x44, 0x13, 0x79, 0x22, 0xCA, 0xB1, 0x18, 0x77, 0xE8, 0xC2, 0x46, 0x8B, 0x95, 0x51, 0x44, 0x66, 0xEC, 0x52, 0x04, 0x4A, 0x39, 0x91, 0x35, 0xD5, 0x57, 0x8E, 0x91, 0x28, 0x7B, 0x74, 0xD2, 0x8B, 0xCC, 0xD8,
	0xBC, 0xE3, 0x88, 0x53, 0xF5, 0x42, 0xC5, 0x1C, 0x87, 0x37, 0xAB, 0xB5, 0xB5, 0xEB, 0x0C, 0x97, 0x4E, 0x75, 0x61, 0x2E, 0x49, 0xB9, 0xCC, 0xB3, 0xB9, 0xDB, 0x31, 0x44, 0x73, 0x34, 0x67, 0xDC, 0xCA, 0x3B, 0x87, 0xC5, 0x58, 0xA5, 0xB4, 0x2C, 0x3C, 0x7C, 0x4F, 0x70, 0xE8, 0x81, 0x2A, 0x24, 0x6E, 0x81,
	0x0A, 0x43, 0x11, 0x30, 0xC0, 0xBC, 0xAB, 0xC7, 0xAA, 0x22, 0x9D, 0x77, 0x33, 0xE3, 0xA8, 0x4B, 0x5A, 0xF1, 0x85, 0x70, 0x8B, 0xB3, 0xD6, 0x6C, 0xC6, 0x40, 0x59, 0xDD, 0x29, 0xCF, 0x97, 0x48, 0xEA, 0x7F, 0xF5, 0x69, 0x96, 0xC6, 0x8F, 0xA3, 0x5C, 0x01, 0x87, 0xE3, 0x3B, 0x63, 0x1B, 0xDA, 0x03, 0xAF,
	0x5E, 0xA2, 0xFC, 0x51, 0x33, 0x78, 0xE4, 0x2E, 0xD6, 0x8F, 0x48, 0xEE, 0x2F, 0xDC, 0xF0, 0xF4, 0xFB, 0xE4, 0x8A, 0x92, 0xD5, 0xBC, 0xCF, 0x8F, 0xB9, 0x3B, 0xC8, 0x19, 0xCA, 0x13, 0xE6, 0xD2, 0x4A, 0x1C, 0x4E, 0xC2, 0x36, 0x66, 0x44, 0x7F, 0x4D, 0x94, 0xED, 0x88, 0x6E, 0x8C, 0x78, 0xA0, 0x68, 0x26,
	0xF0, 0x71, 0xC9, 0x8E, 0x4D, 0xCF, 0x2F, 0x53, 0xC9, 0x3C, 0x2D, 0xAA, 0x5E, 0x31, 0xBF, 0x36, 0x5B, 0x4B, 0x90, 0xBF, 0xBA, 0xAB, 0xD7, 0xEE, 0x3F, 0x44, 0x2A, 0x6B, 0x3C, 0xF4, 0x9C, 0x10, 0xAA, 0x9C, 0x8A, 0xD3, 0xB7, 0x9A, 0xEB, 0x16, 0x72, 0x25, 0x6E, 0x05, 0x20, 0xAD, 0x2E, 0xFD, 0x76, 0x89,
	0x94, 0xE7, 0x48, 0x43, 0xAF, 0x44, 0x5E, 0x4C, 0xF2, 0x02, 0x00, 0xB0, 0xFC, 0x8E, 0xF5, 0x05, 0xF5, 0x97, 0xC6, 0x3C, 0xB3, 0xCC, 0xD0, 0xEE, 0xD3, 0x4D, 0x59, 0xBA, 0x1C, 0x2C, 0xEB, 0xAC, 0x69, 0x07, 0xC7, 0x8C, 0x1A, 0x77, 0xCA, 0x34, 0x6E, 0xF5, 0x26, 0x18, 0x3B, 0x05, 0x31, 0x84, 0x84, 0x51,
	0xA1, 0xF6, 0x91, 0x09, 0x44, 0xDF, 0x28, 0x05, 0x05, 0x16, 0x54, 0xC7, 0x71, 0x1B, 0x28, 0xD9, 0xA3, 0xF8, 0xB9, 0x06, 0x6E, 0xD8, 0x48, 0xC5, 0x3D, 0x41, 0x27, 0x2C, 0x64, 0x9B, 0x3E, 0x40, 0x5B, 0xBD, 0x66, 0xE9, 0xB2, 0xE4, 0x14, 0x5D, 0xB5, 0x59, 0xA9, 0x94, 0x21, 0xD2, 0x50, 0x0C, 0x9A, 0x85,
	0x50, 0x77, 0x07, 0xC2, 0x1D, 0x65, 0x0E, 0x02, 0x71, 0x1B, 0x1F, 0x13, 0x27, 0x60, 0x3F, 0x54, 0xE3, 0x58, 0xAD, 0xBE, 0x9B, 0x91, 0xF3, 0x32, 0x2C, 0xD1, 0xC7, 0xFC, 0x65, 0xE5, 0x54, 0xE4, 0x84, 0x2C, 0x0D, 0xCE, 0x06, 0xE2, 0xDD, 0xF3, 0xA1, 0x50, 0x70, 0xDE, 0x3B, 0x65, 0x30, 0x94, 0xE4, 0x9A,
	0x0D, 0x1B, 0x95, 0x47, 0xB0, 0xA8, 0xC6, 0x95, 0x04, 0xD6, 0x70, 0x67, 0xDD, 0xBA, 0x26, 0x07, 0xA8, 0x49, 0x4A, 0x5A, 0xDD, 0xC6, 0x25, 0x27, 0x66, 0xC9, 0x19, 0x1E, 0xCC, 0x64, 0xDD, 0x5C, 0xB3, 0x16, 0x5E, 0xBC, 0x48, 0xB8, 0xB3, 0x65, 0x3C, 0xB9, 0x7A, 0x91, 0x05, 0xDE, 0x2D, 0x2B, 0x69, 0xC8,
	0x17, 0x09, 0x17, 0x2F, 0x57, 0x3A, 0xAB, 0xB8, 0x14, 0x10, 0x32, 0x2D, 0x53, 0x50, 0x50, 0x6E, 0x91, 0x4B, 0xE9, 0x60, 0xD8, 0xC6, 0xDA, 0x24, 0xE2, 0x0F, 0x21, 0xB4, 0x00, 0xD0, 0x3F, 0xB8, 0xE1, 0x9E, 0x44, 0x12, 0x8F, 0x97, 0xC5, 0xFD, 0xAF, 0xE3, 0xE1, 0xD1, 0x4E, 0x3A, 0x1B, 0x41, 0x50, 0xC4,
	0x13, 0x78, 0x00, 0xAB, 0xA1, 0x00, 0x3C, 0xFE, 0x13, 0x01, 0xBA, 0xF5, 0x9F, 0x5B, 0xE1, 0x12, 0x8F, 0xAA, 0x5D, 0xED, 0x20, 0x39, 0x03, 0x44, 0xC4, 0xC8, 0x71, 0xE7, 0x8F, 0x88, 0xAA, 0x50, 0x0F, 0x31, 0x45, 0x52, 0x98, 0xA3, 0xEE, 0x1D, 0x7A, 0xF5, 0xDC, 0xE2, 0xCE, 0x6F, 0x62, 0x64, 0x63, 0xDF,
	0xA3, 0xE9, 0xD7, 0x3D, 0x8F, 0xEF, 0xB1, 0xA9, 0xB4, 0x35, 0x9B, 0x12, 0x65, 0x06, 0x5C, 0x69, 0xBD, 0x9E, 0xB1, 0x7D, 0xAB, 0x1D, 0x40, 0x4D, 0x50, 0x75, 0x1A, 0xAB, 0x8F, 0xFD, 0xE6, 0xC2, 0xA2, 0x44, 0x92, 0x62, 0xAA, 0xAD, 0x15, 0x30, 0xA2, 0xBA, 0xA2, 0x95, 0xB3, 0xD1, 0xDF, 0xD4, 0xA1, 0xF0,
	0xC4, 0x73, 0xA3, 0x8D, 0xD0, 0x86, 0x3E, 0x21, 0xC9, 0xF2, 0x8B, 0xAC, 0x68, 0x8E, 0x61, 0x60, 0x38, 0xE6, 0xEB, 0x1A, 0x02, 0xF5, 0x5F, 0x99, 0x90, 0x4C, 0x0D, 0x3B, 0x71, 0x85, 0xAF, 0xB1, 0x05, 0x9D, 0x1C, 0x0C, 0x67, 0x32, 0x51, 0xC8, 0x2A, 0xED, 0x52, 0x1D, 0xD3, 0x09, 0x71, 0x47, 0x0C, 0xB1,
	0x02, 0x94, 0xA4, 0x6B, 0x9A, 0x79, 0xBA, 0xD8, 0x40, 0x80, 0x00, 0x40, 0xEC, 0x73, 0x83, 0x91, 0x68, 0xE8, 0x52, 0x97, 0xE0, 0xD8, 0x1D, 0xBD, 0x03, 0x4D, 0x43, 0x4D, 0x34, 0xD4, 0x3A, 0xFF, 0x00, 0xF4, 0x56, 0x73, 0x68, 0x61, 0xFF, 0x00, 0x7B, 0x75, 0x0D, 0x35, 0x00, 0x37, 0xC9, 0x60, 0xCE, 0xC6,
	0x27, 0x8E, 0xBF, 0x29, 0x8A, 0x02, 0x1E, 0xE1, 0x00, 0x1F, 0x77, 0x58, 0x92, 0x3F, 0x0C, 0x61, 0x9C, 0x8D, 0x95, 0x65, 0xD8, 0x71, 0xA9, 0xAA, 0x2E, 0x8D, 0x42, 0xA9, 0x3E, 0x9A, 0x46, 0x33, 0xEA, 0x32, 0x0D, 0xC1, 0x4E, 0xCC, 0x8C, 0xD9, 0x1B, 0x26, 0xC2, 0x21, 0xC8, 0xA6, 0x42, 0x1F, 0x61, 0xDC,
	0x13, 0x7A, 0x40, 0x41, 0x1F, 0x60, 0x06, 0x99, 0x2A, 0x1B, 0x9C, 0xF1, 0x59, 0x4F, 0x8A, 0x35, 0x36, 0x11, 0x75, 0xE3, 0x63, 0xE9, 0xC7, 0x4F, 0x71, 0x83, 0x36, 0x37, 0x69, 0x89, 0x55, 0x66, 0xC6, 0x5E, 0x27, 0x7C, 0xDA, 0x96, 0x54, 0x0B, 0x23, 0x1A, 0xDD, 0x8A, 0x4E, 0x40, 0xA5, 0xEC, 0xAA, 0x42,
	0x9B, 0xC8, 0x75, 0x1E, 0xAE, 0xF8, 0x1A, 0xAF, 0xC4, 0xCC, 0xD9, 0x7A, 0x9D, 0xC1, 0x96, 0x5B, 0x16, 0x1E, 0x8D, 0x9A, 0x7F, 0x7F, 0xC4, 0xB0, 0xF5, 0x5B, 0x79, 0xF1, 0xA4, 0xAB, 0xEA, 0x6B, 0x7B, 0x22, 0x13, 0x50, 0xF2, 0xF3, 0xD2, 0x04, 0x8B, 0x9E, 0x4E, 0x10, 0xAF, 0x13, 0x14, 0x22, 0x94, 0x0E,
	0xDA, 0xFA, 0x00, 0x06, 0x80, 0x1D, 0x61, 0x9E, 0x4F, 0xDC, 0x6A, 0x30, 0x54, 0x4B, 0x06, 0x53, 0x2E, 0x41, 0x74, 0xEA, 0xA5, 0x5A, 0x93, 0x92, 0x98, 0x87, 0x85, 0x6D, 0x57, 0xCA, 0x97, 0x8A, 0x44, 0x43, 0x74, 0x25, 0x25, 0xDA, 0xB2, 0x7E, 0xF9, 0xCA, 0xB0, 0xF5, 0x96, 0xEA, 0xB9, 0x50, 0xC9, 0x26,
	0x41, 0x74, 0xA2, 0x9D, 0xB2, 0x82, 0x7B, 0x3A, 0xFF, 0x00, 0x9D, 0x7F, 0xC4, 0x75, 0xFB, 0x78, 0xB5, 0xC0, 0x6B, 0x36, 0x17, 0xE4, 0x74, 0xF7, 0x10, 0xE2, 0xB3, 0xC5, 0x0B, 0x2E, 0x73, 0xF3, 0x27, 0xD6, 0x38, 0xDD, 0x96, 0xAF, 0x98, 0xA2, 0x62, 0x9B, 0x46, 0x86, 0x6F, 0x93, 0x71, 0x16, 0x02, 0x34,
	0xDD, 0x7E, 0x9B, 0x37, 0x11, 0x74, 0x83, 0xC9, 0x59, 0x01, 0x08, 0x82, 0x5A, 0x4C, 0xD8, 0x8E, 0x18, 0x46, 0x34, 0x29, 0x12, 0x5D, 0xC2, 0x4E, 0x0A, 0xB2, 0x49, 0x4D, 0xDA, 0xE6, 0xFD, 0x3A, 0xF8, 0x6B, 0xFA, 0x3C, 0x24, 0x34, 0x95, 0x82, 0x51, 0x46, 0x3C, 0x54, 0xC6, 0x8E, 0xA4, 0xCB, 0x19, 0x1F,
	0x18, 0xAB, 0xB7, 0xCE, 0x19, 0x45, 0x31, 0xA4, 0x29, 0x38, 0xBC, 0x97, 0xD2, 0x26, 0x60, 0x4D, 0x26, 0xA4, 0x33, 0xA3, 0x28, 0x25, 0x28, 0x01, 0x8F, 0xD7, 0x28, 0xF8, 0x45, 0x7B, 0xC2, 0x1C, 0xC2, 0x61, 0xC2, 0x3B, 0x4F, 0x22, 0x2C, 0xF6, 0xFE, 0x04, 0x67, 0x0B, 0x67, 0x17, 0x73, 0xB3, 0x18, 0x14,
	0x2B, 0xB6, 0x49, 0xA7, 0xAC, 0x5C, 0x52, 0xAD, 0xE3, 0x27, 0x46, 0x75, 0x2F, 0x50, 0x6D, 0x23, 0x0E, 0xDD, 0x83, 0xF6, 0x8F, 0xE5, 0x05, 0x16, 0x6E, 0xDD, 0xFD, 0x73, 0x81, 0x38, 0x7D, 0x49, 0x44, 0x73, 0x27, 0x22, 0x1E, 0xE1, 0x8E, 0x5C, 0x45, 0x71, 0xF3, 0x26, 0x70, 0xCB, 0x08, 0x71, 0x8E, 0x97,
	0x98, 0x65, 0xF8, 0x95, 0x9F, 0x23, 0xE8, 0xF3, 0x19, 0x46, 0xAD, 0x99, 0xAD, 0xF6, 0xF9, 0x16, 0x0A, 0xBF, 0x5B, 0x1F, 0x0B, 0xF8, 0x8A, 0x89, 0x98, 0xDE, 0x92, 0x32, 0x53, 0x6E, 0x91, 0x6D, 0x14, 0xB2, 0xA9, 0x1C, 0x7E, 0xA4, 0xC9, 0x6C, 0x39, 0xAE, 0xF5, 0x1C, 0x6E, 0xD6, 0x4A, 0x37, 0xD3, 0x03,
	0xD4, 0x2C, 0x98, 0xEF, 0x95, 0x7C, 0xE7, 0xAC, 0xB3, 0x8A, 0x51, 0x7A, 0x74, 0xDE, 0x57, 0xE3, 0x3D, 0xAD, 0x6B, 0x22, 0xD8, 0x9D, 0xDA, 0xC8, 0xC6, 0x2D, 0x15, 0x08, 0x96, 0x76, 0xBD, 0x3B, 0x8A, 0x93, 0x96, 0x48, 0x4A, 0xA3, 0xB9, 0xE6, 0x0E, 0x65, 0x91, 0x15, 0x7B, 0x29, 0x09, 0x07, 0xD3, 0x2E,
	0x37, 0x08, 0x60, 0xAE, 0x54, 0xE5, 0xD4, 0x38, 0x2F, 0xCF, 0xAA, 0x6E, 0x64, 0xE4, 0x6D, 0x8A, 0x83, 0xC5, 0xCC, 0xC7, 0x60, 0xA8, 0x56, 0x28, 0xD5, 0x1B, 0x55, 0x2C, 0x93, 0xE7, 0x83, 0xB1, 0xB6, 0xA9, 0x35, 0x88, 0xBC, 0xC9, 0x37, 0x6D, 0x12, 0xEB, 0x73, 0x78, 0x67, 0x0E, 0x80, 0xE2, 0x91, 0x80,
	0x04, 0x0C, 0x1B, 0x0B, 0x5F, 0xC9, 0xF4, 0x44, 0xED, 0x6D, 0x6B, 0x96, 0x0F, 0xAC, 0x2B, 0x36, 0xD7, 0x5A, 0x4D, 0xBF, 0x1C, 0x59, 0xDB, 0x2A, 0xD1, 0xD2, 0xCC, 0xDC, 0xB0, 0x98, 0xA8, 0xDF, 0xE0, 0xAB, 0x96, 0x88, 0x77, 0x69, 0x2E, 0x8E, 0x86, 0x2A, 0x8D, 0x0A, 0x23, 0xB7, 0x52, 0x18, 0xE4, 0x12,
	0x9C, 0xDE, 0x96, 0x79, 0x3F, 0x15, 0x60, 0x0E, 0x5C, 0xE5, 0x0C, 0x65, 0xC1, 0x6C, 0xE1, 0x95, 0xE5, 0xF9, 0x2B, 0x7E, 0xC7, 0xFC, 0x59, 0xCD, 0xB3, 0x95, 0xAA, 0xD2, 0x73, 0x61, 0x03, 0x50, 0x43, 0xF6, 0xC2, 0xC4, 0xA5, 0xEB, 0x7C, 0xFA, 0x17, 0x71, 0xAF, 0x96, 0x74, 0x30, 0xC0, 0xF4, 0x48, 0xDC,
	0x00, 0x41, 0x40, 0x38, 0x08, 0x05, 0x63, 0x24, 0x53, 0x8F, 0x36, 0xA5, 0x6A, 0xDA, 0xC4, 0xF2, 0x51, 0x43, 0x64, 0xAC, 0xD8, 0x69, 0xB3, 0xA5, 0x40, 0xAE, 0xDC, 0xB5, 0x51, 0x29, 0x3A, 0xC5, 0xAE, 0x2E, 0x12, 0xC5, 0x0C, 0xE5, 0x17, 0x0D, 0x8E, 0x41, 0x45, 0xDB, 0x54, 0x96, 0xD0, 0xA0, 0x22, 0x02,
	0x02, 0x06, 0x1E, 0x03, 0xFA, 0xB8, 0x71, 0x4B, 0x08, 0x58, 0x79, 0x3A, 0xDF, 0x89, 0x6C, 0xEE, 0x78, 0xEF, 0x90, 0x18, 0x32, 0x8A, 0x2E, 0x15, 0xC8, 0xF3, 0x18, 0xAA, 0xDC, 0x93, 0xF2, 0xB8, 0x9C, 0xA7, 0xC5, 0x36, 0x03, 0x2B, 0x2E, 0xA4, 0x74, 0x6D, 0x96, 0x4C, 0xE7, 0x22, 0x44, 0x59, 0x74, 0x9E,
	0xA4, 0xC8, 0xCA, 0x24, 0x76, 0x7F, 0x54, 0x24, 0x6C, 0x4C, 0x65, 0xC5, 0x9F, 0x51, 0x3B, 0xF6, 0x6D, 0x93, 0x6C, 0xD5, 0x28, 0x9E, 0x39, 0x33, 0xE1, 0x9E, 0x56, 0x8B, 0xBD, 0x29, 0x67, 0x7C, 0x8B, 0x74, 0xA3, 0xEB, 0xD3, 0x36, 0xA9, 0x18, 0xB1, 0xC5, 0xD5, 0xE6, 0xE4, 0x90, 0x39, 0x51, 0x71, 0x24,
	0x79, 0xB5, 0x18, 0xA0, 0x91, 0x15, 0x58, 0x0C, 0xA0, 0x14, 0x04, 0xD9, 0xEB, 0x36, 0xF2, 0xD2, 0x3D, 0xB5, 0x63, 0x3B, 0xF2, 0x8F, 0x90, 0x79, 0xC7, 0x9C, 0x39, 0xD2, 0x89, 0x52, 0xFD, 0x42, 0xF0, 0x96, 0x2C, 0x3E, 0x47, 0x33, 0x23, 0x57, 0xB1, 0x2C, 0x33, 0x98, 0x28, 0xF7, 0x12, 0x56, 0xD5, 0x31,
	0xD6, 0x3F, 0xAB, 0x45, 0xB0, 0x53, 0xE8, 0xDB, 0x1C, 0xC7, 0x78, 0x45, 0x93, 0x4F, 0xBA, 0x00, 0x07, 0x3F, 0xA9, 0x7E, 0x4A, 0xB2, 0xE1, 0xDE, 0x56, 0xD1, 0xF1, 0x57, 0x32, 0x27, 0x78, 0x65, 0x0B, 0xC6, 0x9C, 0x93, 0x7B, 0xE2, 0xBE, 0x7D, 0xAC, 0x53, 0xAE, 0x67, 0xC4, 0xB8, 0x61, 0x6C, 0x73, 0x72,
	0x6E, 0xFA, 0x5A, 0x52, 0x88, 0xD8, 0xD4, 0x73, 0x85, 0xD1, 0x55, 0xFE, 0x90, 0xF3, 0x0D, 0xD9, 0xA2, 0xE5, 0xA0, 0xA6, 0xE0, 0x8A, 0x0A, 0x4A, 0x10, 0xC6, 0xA7, 0x65, 0x4C, 0x03, 0x60, 0x6B, 0x89, 0xF9, 0xFF, 0x00, 0xC5, 0x49, 0x32, 0x64, 0xDE, 0x25, 0x66, 0x96, 0x2E, 0x4B, 0x0D, 0x27, 0x19, 0x64,
	0x88, 0x74, 0x49, 0x80, 0xC7, 0x36, 0x19, 0xC2, 0x15, 0xD1, 0xC2, 0xA9, 0x69, 0x5D, 0x80, 0x94, 0x0E, 0xE4, 0xA7, 0x6A, 0xD5, 0xF8, 0x11, 0x61, 0x4C, 0x52, 0x33, 0x92, 0x1F, 0x10, 0xDB, 0x79, 0x5D, 0x4B, 0xCA, 0x34, 0x9B, 0xFD, 0x1E, 0xDB, 0xCA, 0x19, 0x8C, 0xC1, 0x53, 0x53, 0x17, 0xDB, 0x65, 0x72,
	0x32, 0x76, 0xFB, 0x17, 0x2E, 0x73, 0x44, 0x9C, 0xB2, 0xB1, 0xB8, 0xC2, 0x97, 0x5E, 0x79, 0x66, 0x99, 0x56, 0x76, 0x4E, 0x70, 0xCE, 0xDA, 0xB6, 0x8C, 0x62, 0xA8, 0x28, 0xD5, 0x74, 0xD5, 0x6E, 0x98, 0xA0, 0x64, 0xCD, 0xD7, 0xAB, 0x25, 0xF7, 0x30, 0xE0, 0x1E, 0x5A, 0x62, 0x4A, 0x9F, 0x3C, 0xF9, 0x5F,
	0x58, 0xBB, 0xF1, 0xAA, 0xCD, 0x90, 0xF8, 0xC1, 0x99, 0xE1, 0xAB, 0xD6, 0xB8, 0x05, 0xEE, 0x59, 0x6D, 0x06, 0x8B, 0x58, 0x25, 0x82, 0xA6, 0xBA, 0x54, 0x67, 0x4E, 0x53, 0xB8, 0x47, 0x2A, 0x92, 0x12, 0xE0, 0xC8, 0x53, 0x68, 0x61, 0x15, 0x7B, 0x67, 0xDE, 0x50, 0x32, 0xA2, 0x82, 0x5D, 0xC5, 0x43, 0x62,
	0x87, 0x12, 0x10, 0x54, 0x39, 0x13, 0x39, 0xC4, 0x89, 0x9C, 0xDA, 0x9C, 0x4C, 0x54, 0xCC, 0x71, 0xD0, 0x04, 0x74, 0x01, 0x11, 0xF6, 0x07, 0x87, 0x58, 0xD2, 0x81, 0x01, 0x96, 0xD1, 0xC4, 0x56, 0xBC, 0x3F, 0x91, 0x95, 0xC9, 0x35, 0x77, 0x92, 0x35, 0x95, 0x6C, 0x75, 0xCB, 0x0B, 0xD7, 0x35, 0xC9, 0x0A,
	0xBB, 0x88, 0x3B, 0x0A, 0x2C, 0x64, 0xE2, 0xA4, 0xD8, 0x46, 0x99, 0xAC, 0xB9, 0x95, 0x07, 0x0D, 0x45, 0x55, 0x13, 0x59, 0x32, 0x88, 0x10, 0x44, 0x35, 0x00, 0x61, 0x33, 0xC8, 0x1E, 0x2F, 0xC5, 0x57, 0x83, 0x62, 0x06, 0xB1, 0xC6, 0xA9, 0x95, 0xE7, 0x65, 0x54, 0x68, 0x7E, 0xE1, 0x95, 0x32, 0x15, 0xD7,
	0xD5, 0x08, 0xC4, 0x9C, 0xAD, 0xB1, 0x70, 0x01, 0x05, 0xE4, 0x00, 0xA6, 0x31, 0x75, 0x31, 0x8D, 0xAE, 0xA3, 0x86, 0x78, 0xB6, 0x8D, 0xD9, 0xC6, 0x45, 0x0C, 0x53, 0x19, 0x65, 0x66, 0xB5, 0xCD, 0xCC, 0x32, 0x30, 0x0A, 0x4D, 0x3C, 0xB3, 0xDE, 0x2C, 0xF7, 0x77, 0xC7, 0x2C, 0x42, 0x0F, 0x24, 0x13, 0x64,
	0xDD, 0x93, 0xEB, 0x32, 0x8D, 0x91, 0x0E, 0xF1, 0xCC, 0x64, 0x91, 0x29, 0x8D, 0xA1, 0x8C, 0x20, 0x1E, 0xDF, 0xB4, 0xBF, 0x27, 0x73, 0x69, 0xF6, 0xFC, 0xBB, 0xF6, 0xEA, 0x4E, 0xE6, 0xDF, 0xCD, 0xA6, 0xBB, 0x77, 0x7E, 0x1D, 0x17, 0x6F, 0x6F, 0x5D, 0xBF, 0x0E, 0x9B, 0x75, 0xDB, 0xFD, 0xBF, 0x97, 0xDC,
	0x1A, 0x6C, 0xFF, 0x00, 0xB7, 0xEE, 0xEB, 0xF2, 0x6B, 0xF1, 0xFF, 0x00, 0x4E, 0xBE, 0x5D, 0xC0, 0xD3, 0xF0, 0x0D, 0xDD, 0x0E, 0xD1, 0x4F, 0x76, 0xE3, 0xEE, 0xD3, 0x6E, 0xBB, 0x80, 0x4B, 0xDC, 0xD7, 0x4F, 0x03, 0x08, 0xED, 0xDD, 0xD0, 0xEF, 0xED, 0xFC, 0xA7, 0xF9, 0xB6, 0xFF, 0x00, 0xE3, 0xF8, 0x7B,
	0x9E, 0x3F, 0x93, 0xC3, 0x77, 0x97, 0x5F, 0x16, 0xDF, 0xBF, 0x5D, 0x3E, 0xFF, 0x00, 0x78, 0xFF, 0x00, 0x1E, 0x8F, 0xF2, 0xFF, 0x00, 0xA9, 0xE1, 0xEE, 0xFC, 0xFF, 0x00, 0x87, 0xBF, 0xA0, 0xDD, 0xB3, 0x77, 0x96, 0xED, 0xBB, 0xBC, 0x07, 0x5F, 0x11, 0xD4, 0x7D, 0x9F, 0x60, 0x6B, 0xB7, 0x7F, 0xE5, 0xD7,
	0x6E, 0xFF, 0x00, 0x03, 0x78, 0x79, 0xE9, 0xA6, 0xBF, 0xCF, 0xA0, 0xF9, 0x75, 0xDA, 0x6F, 0x76, 0xBA, 0x6A, 0x1B, 0xBF, 0xCB, 0xAF, 0x8F, 0x43, 0xBB, 0x4F, 0x94, 0x75, 0xD7, 0x4F, 0x97, 0xCF, 0x5D, 0x7F, 0x2F, 0x41, 0xBB, 0x6E, 0xBE, 0x5A, 0xE9, 0xAF, 0xCC, 0x5F, 0x0F, 0x6F, 0xF5, 0xED, 0xFC, 0x74,
	0xE8, 0x36, 0xF6, 0xBC, 0xB6, 0xE9, 0xB7, 0xDC, 0x9E, 0xDD, 0xBA, 0x7D, 0xDB, 0x7F, 0x97, 0x45, 0xDD, 0xDB, 0xF9, 0xBE, 0x0D, 0x76, 0xFC, 0xDD, 0xC2, 0x7C, 0xBF, 0xF5, 0x77, 0xB6, 0xFF, 0x00, 0x9B, 0x4F, 0x3E, 0x83, 0x6F, 0x6F, 0x6F, 0xC1, 0xA6, 0xDD, 0xBA, 0x7F, 0xA7, 0xA6, 0x9E, 0xCF, 0xE1, 0xF6,
	0x0E, 0xBB, 0x75, 0xF3, 0xF0, 0xF7, 0x7F, 0x88, 0x7B, 0x3A, 0x1D, 0xDB, 0x36, 0xE9, 0xF1, 0x6E, 0xD3, 0x4D, 0x3E, 0xFD, 0x7C, 0xBA, 0x0D, 0x9B, 0x76, 0xF9, 0x6D, 0xD3, 0x4F, 0xE5, 0xD0, 0xE9, 0xAF, 0xE1, 0xAF, 0x86, 0x9F, 0x77, 0x96, 0xBD, 0x7F, 0xFF, 0xD9
};

// forward declarations
void SetDocumentInfoTest(LPPDFINFO pdev);
void DrawPolygonTest(LPPDFINFO pdev);
void DrawTextTest(LPPDFINFO pdev);
void DrawImageTest(LPPDFINFO pdev);
void DrawTableTest(LPPDFINFO pdev);

int main(void)
{
	LPPDFINFO	pdev;

	printf("Welcome to RTPDF Test Program\n");

	// Intialize random number generator, this is needed to generate a pseudo-unique ID for a PDF document
	srand((UINT)time(NULL));
	
	// Initialize the PDF object
	pdev = RTPdfInit();

	if (pdev)
   {
		/// replace by your actual licensee name and license key
		const char *szLicensee = "Licensee";
		const char *szLicenseKey = "07EFCD...55B63E";
		///
		if (RTPdfSetLicenseKey(pdev, szLicenseKey, szLicenseKey, strlen(szLicenseKey)) < 0)
	   {
		   // something is wrong with the license, a demo watermark will be printed across pages
		   printf("Wrong RTPDF License Key, a demo watermark will be printed across pages\n");
	   }

		// set document information before starting the document
		SetDocumentInfoTest(pdev);

		// set the names and order of all layers, this can be called anywhere outside of a page, preferrably before StartDoc
		RTPdfSetLayer(pdev, L"/Order[(Clipped Polygons)[(Clipped Polygons - 1)(Clipped Polygons - 2)] (Some Text)]");

		// document must be started before creating any fonts or images
		if (!RTPdfStartDoc(pdev))
		{
			// failed starting the document, probably an error in RTPdfOpenPort
			printf("Failed starting a new document, check check that RTPdfOpenPort is successful\n");

			// rendering of the PDF can continue but no output will be generated
		}

		// start first page
		RTPdfStartPage(pdev);

		// set a bookmark to the first table on the first page
		RTPdfSetBookmark(pdev, 0, L"Table on Page 1");

		// run the table creation test
		DrawTableTest(pdev);

		// place the next polygon in a PDF layer named "Clipped Polygons - 1" under "Clipped Polygons"
		RTPdfSetLayer(pdev, L"Clipped Polygons");
		RTPdfSetLayer(pdev, L"Clipped Polygons - 1");

		// output some polygons
		DrawPolygonTest(pdev);

		// end previous layers
		RTPdfSetLayer(pdev, L"");
		RTPdfSetLayer(pdev, L"");

		// end first page
		RTPdfEndPage(pdev);

		// change the format of subsequent pages to Legal and the orientation to Landscape
		DEVMODEA	dm;
		memset(&dm, 0, sizeof(dm));
		dm.dmSize = sizeof(dm);
		lstrcpy((LPSTR)dm.dmFormName, "Legal");
		dm.dmOrientation = DMORIENT_LANDSCAPE;
		// specify which DEVMODE fields are being modified
		dm.dmFields |= (DM_FORMNAME | DM_ORIENTATION);
		RTPdfResetDevmode(pdev, &dm);

		// start second page
		RTPdfStartPage(pdev);

		// output some images
		DrawImageTest(pdev);

		// place the next text in a PDF layer named "Some Text""
		RTPdfSetLayer(pdev, L"Some Text");

		// output some text
		DrawTextTest(pdev);

		// end previous layer
		RTPdfSetLayer(pdev, L"");

		// set a bookmark to the first table on the second page
		RTPdfSetBookmark(pdev, 0, L"Table on Page 2");

		// run the table creation test
		DrawTableTest(pdev);

		// place the next polygon in a PDF layer named "Clipped Polygons - 2" under "Clipped Polygons"
		RTPdfSetLayer(pdev, L"Clipped Polygons");
		RTPdfSetLayer(pdev, L"Clipped Polygons - 2");

		// output some polygons
		DrawPolygonTest(pdev);

		// end previous layer
		RTPdfSetLayer(pdev, L"");
		RTPdfSetLayer(pdev, L"");

		// end second page
		RTPdfEndPage(pdev);

		// end document
		RTPdfEndDoc(pdev);

		// free pdev and other library objects
		RTPdfEnd(pdev);
	}

	printf("End of RTPDF Test Program\n");
	while (1);

   return 0;
}

int IsMetricCountry()
{
	return 0;	// default to Letter paper size
}

void SetDocumentInfoTest(LPPDFINFO pdev)
{
	//
	// Set various document attributes in single or double character formats
	//
	UNICODE_STRING us;

	RTPdfSetDocumentInfo(pdev, DocumentInfoTitle, (LPBYTE)"My Document");
	RTPdfSetDocumentInfo(pdev, DocumentInfoAuthor, (LPBYTE)"Amyuni Technologies");
	RTPdfSetDocumentInfo(pdev, DocumentInfoCreator, (LPBYTE)"RTPDF-32 v1.0");

	INIT_UNICODE_STRING(us, "\x2A\x59\x1F\x61\x22\x8C\x86\x4E");	// simplified chinese for Thank you so much
	RTPdfSetDocumentInfo(pdev, DocumentInfoSubject, (LPBYTE)&us);

	RTPdfSetDocumentInfo(pdev, DocumentInfoKeywords, (LPBYTE)"RTPDF,Test");
}

HANDLE GetImageFromFile(LPPDFINFO pdev, LPCSTR lpszFileName)
{
	//
	// Open image file from disk and load it into the PDF object
	//
	DWORD dwFileSize, dwFileSizeHigh;
	HANDLE hImg = NULL;
	HANDLE hf = CreateFile(lpszFileName, GENERIC_READ, 0, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);
	if (hf != INVALID_HANDLE_VALUE)
	{
		dwFileSize = GetFileSize(hf, &dwFileSizeHigh);
		LPBYTE lpb = (LPBYTE)malloc(dwFileSize);
		if (lpb)
		{
			// read the image data into memory
			ReadFile(hf, lpb, dwFileSize, &dwFileSizeHigh, NULL);

			// save the image to the PDF object
			hImg = RTPdfGetImage(pdev, lpb, dwFileSize);

			// image data is already output to the PDF, can clear the data now
			free(lpb);
		}
		CloseHandle(hf);
	}

	return hImg;
}

void DrawTextTest(LPPDFINFO pdev)
{
	// Load fonts
	HANDLE	hFnt1 = RTPdfGetFont(pdev, "Helvetica", 0, 0, 0, 1, 0);
	HANDLE	hFnt2 = RTPdfGetFont(pdev, "Helvetica-Bold", 0, 0, 0, 1, 0);

	// output some text
	const char TEXT1[] = "RTPDF Text Output 1";
	const char TEXT2[] = "RTPDF Text Output 2";
	const char TEXT3[] = "RTPDF Rotated Text Output 1";
	const char TEXT4[] = "RTPDF Rotated Text Output 2";

	BRUSHOBJ	brush = { RGB2GDIBRUSH(0x00, 0x55, 0xAF), 0, 0 };	// blue-ish
	BRUSHOBJ	brush2 = { RGB2GDIBRUSH(0xAF, 0x00, 0x55), 0, 0 };	// red-ish

	RTPdfSetFont(pdev, hFnt1, 10.4f);
	RTPdfSetTextSpacing(pdev, FLOAT2LONG(2.0f), FLOAT2LONG(1.0f));
	RTPdfTextOut(pdev, NULL, &brush, FLOAT2LONG(36.5f), FLOAT2LONG(80.0f), 0.0f, (const BYTE *)TEXT1, strlen(TEXT1), 0);

	RTPdfSetTextSpacing(pdev, 0, 0);
	RTPdfTextOut(pdev, NULL, &brush, FLOAT2LONG(36.5f), FLOAT2LONG(90.0f), 0.0f, (const BYTE *)TEXT1, strlen(TEXT1), 0);
	RTPdfTextOut(pdev, NULL, &brush, FLOAT2LONG(36.5f), FLOAT2LONG(200.0f), 45.0f, (const BYTE *)TEXT3, strlen(TEXT3), 0);

	// create a clipping path to crop the text
	CLIPOBJ	clipPath = {
		0,							// Region Identifier, should be 0
		{ FLOAT2LONG(36.0f), FLOAT2LONG(136.0f), FLOAT2LONG(80.0f), FLOAT2LONG(300.0f) },			// Rectangular region bounds	
		DC_RECT,					// Rectangular clipping region, the only supported value
		FC_RECT,					// Complexity of the region
		0,							// Not used
		0							// Not used
	};

	// output some text with a bold font and clipping
	RTPdfSetFont(pdev, hFnt2, 10.4f);
	RTPdfTextOut(pdev, &clipPath, &brush2, FLOAT2LONG(36.5f), FLOAT2LONG(210.0f), 0.0f, (const BYTE *)TEXT2, strlen(TEXT2), 0);
	RTPdfTextOut(pdev, &clipPath, &brush2, FLOAT2LONG(36.5f), FLOAT2LONG(300.0f), 45.0f, (const BYTE *)TEXT4, strlen(TEXT4), 0);
}

void DrawImageTest(LPPDFINFO pdev)
{
	// Load images
	HANDLE  hImg1 = GetImageFromFile(pdev, "c:\\temp\\test.png");
	HANDLE  hImg2 = GetImageFromFile(pdev, "c:\\temp\\logo.jpg");
	HANDLE  hImg3 = GetImageFromFile(pdev, "c:\\temp\\logo-256.bmp");
	// load an image from memory into the PDF object
	HANDLE	hImg4 = RTPdfGetImage(pdev, Test_Image_Jpeg, sizeof(Test_Image_Jpeg));

	// create a clipping path to crop the image
	CLIPOBJ	clipPath = {
		0,							// Region Identifier, should be 0
		{ FLOAT2LONG(36.0f), FLOAT2LONG(36.0f), FLOAT2LONG(80.0f), FLOAT2LONG(80.0f) },			// Rectangular region bounds	
		DC_RECT,					// Rectangular clipping region, the only supported value
		FC_RECT,					// Complexity of the region
		0,							// Not used
		0							// Not used
	};

	// draw images
	RTPdfDrawImage(pdev, &clipPath, hImg1, FLOAT2LONG(36.0f), FLOAT2LONG(36.0f), FLOAT2LONG(72.5f), FLOAT2LONG(0.0f), FALSE);
	RTPdfDrawImage(pdev, NULL, hImg2, FLOAT2LONG(36.0f), FLOAT2LONG(120.0f), FLOAT2LONG(150.0f), FLOAT2LONG(0.0f), FALSE);
	RTPdfDrawImage(pdev, NULL, hImg3, FLOAT2LONG(36.0f), FLOAT2LONG(220.0f), FLOAT2LONG(150.0f), FLOAT2LONG(0.0f), FALSE);
	RTPdfDrawImage(pdev, NULL, hImg4, FLOAT2LONG(36.0f), FLOAT2LONG(320.0f), FLOAT2LONG(150.0f), FLOAT2LONG(0.0f), FALSE);

	// set a hyperlink on the last image object to an external URL
	RTPdfSetHyperLink(pdev, NULL, L"https://www.amyuni.com");
}


void DrawPolygonTest(LPPDFINFO pdev)
{
	PATHOBJ	*ppo = RTPdfCreatePath(pdev);
	// Path coordinates as defined by Windows GDI are in fixed point units, which is the value multipled by 16 for higher precision
	POINTFIX pfx1 = { FLOAT2FIX(100.4f), FLOAT2FIX(100.0f) };
	POINTFIX pfx2[] = { { FLOAT2FIX(200.6f), FLOAT2FIX(200.0f) },
	{ FLOAT2FIX(300.6f), FLOAT2FIX(200.0f) }
	};
	POINTFIX pfx3[] = { { FLOAT2FIX(300.6f), FLOAT2FIX(200.0f) },
	{ FLOAT2FIX(450.6f), FLOAT2FIX(230.0f) },
	{ FLOAT2FIX(300.6f), FLOAT2FIX(180.0f) }
	};
	BRUSHOBJ stroke_brush = { RGB2GDIBRUSH(0x00, 0x55, 0xAF), 0, 0 };	// blue-ish
	BRUSHOBJ fill_brush = { RGB2GDIBRUSH(0x00, 0xAF, 0x55), 0, 0 };		// green-ish

	LINEATTRS	ContinuousThickLine = {
		0,					// Option flags, should be 0
		JOIN_ROUND,			// Join style
		ENDCAP_ROUND,		// End cap style
		0,					// Line width
		0,					// Not used
		0,					// Number of entries in the style array
		NULL,				// Style array for non-continuous lines
		0					// Not used
	};
	ContinuousThickLine.elWidth.l = 20;		// line width in pixels x 10

											// create a dashed line with a proportion of 5 to 1
	FLOAT_LONG	DashedLineStyle[2];
	DashedLineStyle[0].l = 10;
	DashedLineStyle[1].l = 2;
	LINEATTRS	DashedLine = {
		0,							// Option flags, should be 0
		JOIN_ROUND,					// Join style
		ENDCAP_ROUND,				// End cap style
		0,							// Line width
		0,							// Not used
		_countof(DashedLineStyle),	// Number of entries in the style array
		DashedLineStyle,			// Style array for non-continuous lines
		0							// Not used
	};
	DashedLine.elWidth.l = 10;		// line width in pixels x 10

	CLIPOBJ	clipPath = {
		0,							// Region Identifier, should be 0
		{ FLOAT2LONG(200.0f), FLOAT2LONG(150.0f), FLOAT2LONG(400.0f), FLOAT2LONG(350.0f) },			// Rectangular region bounds	
		DC_RECT,					// Rectangular clipping region, the only supported value
		FC_RECT,					// Complexity of the region
		0,							// Not used
		0							// Not used
	};

	PATHOBJ_bMoveTo(ppo, pfx1);
	PATHOBJ_bPolyLineTo(ppo, pfx2, _countof(pfx2));
	PATHOBJ_bPolyBezierTo(ppo, pfx3, _countof(pfx3));
	// close our random figure
	PATHOBJ_bPolyLineTo(ppo, &pfx1, 1);

	RTPdfStrokeAndFillPath(pdev, ppo, &clipPath, &stroke_brush, &DashedLine, &fill_brush, NULL, 0, PDF_PATH_FILLANDSTROKE);

	// set a hyperlink on the last path object to an external URL
	RTPdfSetHyperLink(pdev, NULL, L"https://www.amyuni.com");

	RTPdfDeletePath(ppo);
}

void DrawTable(LPPDFINFO pdev, float left, float top)
{
	acTable	table;
	RECT	rc, rcTable = { FLOAT2LONG(left), FLOAT2LONG(top), FLOAT2LONG(left+530.0f), FLOAT2LONG(top+240.0f) };
	int		rows = 5, cols = 4;
	acReportCell *cell;

	table.InitTable(rows, cols, rcTable);

	table.SetColWidth(0, FLOAT2LONG(150.0f), TRUE);		// enlarge first column
	table.SetColWidth(1, FLOAT2LONG(75.0f), TRUE);		// reduce second column
	table.SetColWidth(2, FLOAT2LONG(175.0f), FALSE);	// enlarge column 3 and reduce column 4

	table.SetRowHeight(0, FLOAT2LONG(25.0f), 1);		// header row a bit smaller

														// set a default font for all the table
	HANDLE	hFnt1 = RTPdfGetFont(pdev, "Helvetica", 0, 0, 0, 1, 0);
	HANDLE  hFnt2 = RTPdfGetFont(pdev, "Helvetica-Bold", 0, 0, 0, 1, 0);

	for (int r = 0; r < rows; r++)
		for (int c = 0; c < cols; c++)
		{
			acReportCell *cell = table.GetCell(r, c);

			cell->horzBorders = acReportCell::HorzBorders::acHorzBorderBoth;
			cell->font = hFnt1;
			cell->pointSize = 11.5f;
			cell->titleFont = hFnt2;
			cell->titlePointSize = 9.0f;
			cell->borderWidth = 10;

			// make the first row different from the others
			if (r == 0)
			{
				cell->backColor = RGB(0, 0xAA, 0xFF);
				cell->textColor = RGB(0xFF, 0xFF, 0xFF);
			}
			else
			{
				cell->vertBorders = acReportCell::VertBorders::acVertBorderBoth;

				if (c == cols - 1)
				{
					// text in last column is right-aligned
					cell->horzAlign = acReportCell::HorzAlign::Right;
				}
			}
		}

	// merge the cells of the first row and set some text
	table.MergeCells(0, 0, cols - 1, 0);
	cell = table.GetCell(0, 0);
	cell->horzAlign = acReportCell::HorzAlign::HCentered;
	cell->SetText("Header Row");

	// merge 4 cells and set a background image and a title
	table.MergeCells(1, 2, 2, 3);
	cell = table.GetCell(2, 1);
	cell->horzAlign = acReportCell::HorzAlign::HCentered;
	cell->backBmp = GetImageFromFile(pdev, "c:\\temp\\test.png");
	cell->SetTitleText("Image with a title");

	cell = table.GetCell(3, 0);
	cell->SetTitleText("Title");
	cell->SetText("Cell contents clipped to boundaries");
	cell->clipToBoundaries = TRUE;

	cell = table.GetCell(2, cols - 1);
	cell->SetText("0.00");

	cell = table.GetCell(3, cols - 1);
	cell->SetText("100.00");
	cell->textColor = RGB(0, 0, 0xFF);

	table.Draw(pdev);

	// set a hyperlink on cell [1,1] to different location on the document (Bookmark)
	table.GetCellsBoundRect(3, 3, 3, 3, rc);
	// the cell coordinates are relative to the table origin and have to be offset by the origin of the table
	RECTL rcl = { rc.left + rcTable.left, rc.top + rcTable.top, rc.right + rcTable.left, rc.bottom + rcTable.top };
	RTPdfSetHyperLink(pdev, &rcl, L"#Table on Page 1");
}

void DrawTableTest(LPPDFINFO pdev)
{
	// draw same table twice for testing
	DrawTable(pdev, 50.0f, 50.0f);
	DrawTable(pdev, 50.0f, 400.0f);
}

#if 1
HANDLE RTPdfOpenPort(const char *szDocTitle, const unsigned long dwJobId)
{
	// construct a file name in the temp folder based on the document title
	CHAR fileName[MAX_PATH];
	sprintf_s(fileName, sizeof(fileName), "c:\\temp\\%s.pdf", (szDocTitle && szDocTitle[0] && szDocTitle[0] != -1) ? szDocTitle : "NoTitle");	// if we have a valid document title, use it, otherwise create "NoTitle.pdf"
																															// szDocTitle[0] is -1 (0xFF) when the title is Unicode

	HANDLE hFile = (HANDLE)CreateFile(fileName, GENERIC_WRITE, 0, NULL, CREATE_ALWAYS, FILE_ATTRIBUTE_NORMAL, NULL);
	if (hFile == INVALID_HANDLE_VALUE)
	{
		printf("Error opening file %s for writing, error code %d\n", fileName, GetLastError());
		return NULL;
	}
	else
	{
		return hFile;
	}
}

int RTPdfWritePort(HANDLE hPort, const unsigned char* pData, unsigned long *pdwDataSize)
{
	if (!WriteFile(hPort, pData, *pdwDataSize, pdwDataSize, NULL))
	{
		printf("Error writing to file, error code %d\n", GetLastError());
		return FALSE;
	}
	else
	{
		return TRUE;
	}
}

int RTPdfClosePort(HANDLE hPort, int bCancel)
{
	return CloseHandle(hPort);
}

#else

// sample callback functions to output PDF data to serial port
HANDLE RTPdfOpenPort(const char *szDocTitle, const unsigned long dwJobId)
{
	RTMPSetAPICModeACPI(0);                // switch to APIC mode, if supported by this target
	if (!RTInitCOMPort(Port,                    // Port to initialize
		RTDefaultCOMIOBase[Port],// I/O base address
		RTDefaultCOMIRQ[Port],   // IRQ
		9600,                    // Baudrate
		PARITY_NONE,             // Parity
		1,                       // Stop bits
		8,                       // Data bits
		1024,                    // Receive buffer size
		1024*8,                    // Send buffer size
		RT_RTS_CTS))             // protocol
	{
		printf("Error opening COM Port\n");
	}

	RTIdleHandler = (void(*)(void)) RTHaltCPL3;  // lets save energy
	
	return (HANDLE)Port;
}

int RTPdfWritePort(HANDLE hPort, const unsigned char* pData, unsigned long *pdwDataSize)
{
	RTSendBlock((int)hPort, pData, *pdwDataSize);
	return 1;
}

int RTPdfClosePort(HANDLE hPort, int bCancel)
{
	RTCloseCOMPort((int)hPort);    // done.
	return 0;
}

#endif

